/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.player.conditions.AbstractCondition;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2561;

public class Pain
extends AbstractCondition {
    int painkillerTicks = 0;
    int painkillerAmount = 0;

    public Pain(Health health) {
        super(health);
    }

    @Override
    class_1291 getEffect() {
        return ModStatusEffects.PAIN;
    }

    @Override
    public void update() {
        super.update();
        class_1657 player = this.getHealth().getPlayer();
        if (this.painkillerTicks > 0) {
            this.painkillerTicks -= 5;
        } else {
            this.painkillerTicks = 0;
            this.painkillerAmount = 0;
        }
        if (this.getAmount() >= 1.0f && player.method_6113()) {
            player.method_18400();
            player.method_7353((class_2561)class_2561.method_43471((String)"zomboidhealthsystem.message.pain_not_sleep"), true);
        }
    }

    @Override
    public float getAmount() {
        return this.getPain();
    }

    @Override
    public void setAmount(float amount) {
    }

    @Override
    public String getName() {
        return "pain";
    }

    @Override
    public String[][] getNbt() {
        String[][] strings = new String[2][2];
        strings[0][0] = "painkiller_ticks";
        strings[0][1] = String.valueOf(this.getPainkillerTicks());
        strings[1][0] = "painkiller_amount";
        strings[1][1] = String.valueOf(this.getPainkillerAmount());
        return strings;
    }

    @Override
    public void readNbt(String text) {
        String ticks = JsonHelper.getValue(text, "painkiller_ticks");
        String amount = JsonHelper.getValue(text, "painkiller_amount");
        if (ticks != null && amount != null) {
            this.painkillerTicks = Integer.parseInt(ticks);
            this.painkillerAmount = Integer.parseInt(amount);
        }
    }

    public void applyEffects() {
        if (this.getPain() >= 1.0f && this.getPain() >= 10.0f) {
            this.health.updateStatusEffect(class_1294.field_5919, 1);
        }
    }

    public int getPainkillerTicks() {
        return this.painkillerTicks;
    }

    public int getPainkillerAmount() {
        return this.painkillerAmount;
    }

    public void setPainkiller(int amount, int ticks) {
        this.painkillerAmount = amount;
        this.painkillerTicks = ticks;
    }

    public void addPainKiller(int amount, int ticks) {
        if (this.painkillerAmount == 0 && this.painkillerTicks == 0) {
            this.painkillerTicks = ticks;
            this.painkillerAmount += amount;
        } else {
            this.painkillerTicks += ticks / 3;
            this.painkillerAmount += amount / (this.painkillerAmount / 2);
        }
    }

    public float getPain() {
        float pain = 0.0f;
        for (Health.BodyPart part : this.getHealth().getBodyParts()) {
            pain += part.getPain();
        }
        return pain / (float)Math.max(this.painkillerAmount, 1) / 2.0f;
    }
}

