/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.world;

import aiven.zomboidhealthsystem.infrastructure.config.JsonBuilder;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;

public class WorldProperties {
    int dayLengthMultiplier;
    int daysInSeason;
    int ticks;
    boolean temperature;

    public WorldProperties() {
        this.dayLengthMultiplier = 3;
        this.daysInSeason = 28;
        this.ticks = 240000;
        this.temperature = true;
    }

    public WorldProperties(int dayLengthMultiplier, int daysInSeason, int ticks, boolean temperature) {
        this.dayLengthMultiplier = dayLengthMultiplier;
        this.daysInSeason = daysInSeason;
        this.ticks = ticks;
        this.temperature = temperature;
    }

    public void setDaysInSeason(int daysInSeason) {
        this.daysInSeason = daysInSeason;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public void setDayLengthMultiplier(int dayLengthMultiplier) {
        this.dayLengthMultiplier = dayLengthMultiplier;
    }

    public void setTemperature(boolean temperature) {
        this.temperature = temperature;
    }

    public int getDaysInSeason() {
        return this.daysInSeason;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getDayLengthMultiplier() {
        return this.dayLengthMultiplier;
    }

    public boolean hasTemperature() {
        return this.temperature;
    }

    public String toString() {
        JsonBuilder builder = new JsonBuilder("[", "]", 2);
        builder.append("day length multiplier", String.valueOf(this.dayLengthMultiplier));
        builder.append("days in season", String.valueOf(this.daysInSeason));
        builder.append("ticks", String.valueOf(this.ticks));
        builder.append("temperature", String.valueOf(this.temperature));
        return builder.toString();
    }

    private static int getInt(String value, int defaultValue) {
        try {
            int val = Integer.parseInt(value);
            return val;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static WorldProperties parseWorldProperties(String value) {
        String dayLengthString = JsonHelper.getValue(value, "day length multiplier");
        String daysInSeasonString = JsonHelper.getValue(value, "days in season");
        String ticksString = JsonHelper.getValue(value, "ticks");
        String temperatureString = JsonHelper.getValue(value, "temperature");
        int dayLength = WorldProperties.getInt(dayLengthString, 3);
        int daysInSeason = WorldProperties.getInt(daysInSeasonString, 28);
        int ticks = WorldProperties.getInt(ticksString, 240000);
        boolean temperature = temperatureString == null ? true : Boolean.parseBoolean(temperatureString);
        WorldProperties properties = new WorldProperties(dayLength, daysInSeason, ticks, temperature);
        return properties;
    }
}

