/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.infrastructure.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class JsonObject {
    private final String pathname;
    private final String path;
    private final String name;
    private final File file;
    private final boolean wasFile;
    private StringBuilder content = new StringBuilder();

    public JsonObject(String path, String name) throws IOException {
        this.path = path;
        this.name = name;
        this.pathname = path + "/" + name;
        this.file = new File(path, name);
        if (this.file.exists()) {
            this.wasFile = true;
            this.content = this.read();
        } else {
            this.wasFile = false;
            this.file.createNewFile();
        }
    }

    public void write(String text) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        fileOutputStream.write(text.getBytes());
        fileOutputStream.close();
        this.content = new StringBuilder(text);
    }

    public void add(String text) {
        this.content.append(text);
    }

    public void delete(String text) {
        this.content = new StringBuilder(this.content.toString().replaceAll(text, ""));
    }

    public void clear() throws IOException {
        this.write("");
    }

    public void deleteFile() {
        this.file.delete();
    }

    public void createFile() throws IOException {
        this.file.createNewFile();
    }

    public void save() throws IOException {
        this.write(this.content.toString());
        this.createFile();
    }

    public StringBuilder read() throws IOException {
        StringBuilder text = new StringBuilder();
        FileInputStream fileInputStream = new FileInputStream(this.file);
        for (byte i : fileInputStream.readAllBytes()) {
            text.append((char)i);
        }
        fileInputStream.close();
        return text;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getPathname() {
        return this.pathname;
    }

    public File getFile() {
        return this.file;
    }

    public boolean wasFile() {
        return this.wasFile;
    }

    public String getContent() {
        return this.content.toString();
    }
}

