/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.gui.hud;

import aiven.zomboidhealthsystem.ConfigKeys;
import aiven.zomboidhealthsystem.foundation.utility.RenderHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import org.joml.Vector2f;

@Environment(value=EnvType.CLIENT)
public enum BodyPartHud {
    HEAD(16, 16, 10, 0),
    BODY(16, 30, 10, 18),
    LEFT_ARM(7, 30, 1, 18),
    RIGHT_ARM(7, 30, 28, 18),
    LEFT_LEG(7, 20, 10, 50),
    RIGHT_LEG(7, 20, 19, 50),
    LEFT_FOOT(7, 7, 10, 72),
    RIGHT_FOOT(7, 7, 19, 72);

    private final int width;
    private final int height;
    private final int x;
    private final int y;
    private int color = Colors.FULL_HEALTH_COLOR.getColor();
    private float hpPercent;
    private int borderColor = Colors.BORDER_COLOR.getColor();
    public static Vector2f POS;

    private BodyPartHud(int width, int height, int x, int y) {
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
    }

    public void renderPart(class_332 context, float tickDelta, Vector2f pos) {
        int posX = (int)pos.x;
        int posY = (int)pos.y;
        RenderHelper.DrawQuad(context, this.width, this.height, this.x + posX, this.y + posY, this.color, this.borderColor);
    }

    private void setColor(int color) {
        this.color = color;
    }

    public void setHp(float hpPercent, boolean addHp, boolean showBandaged) {
        this.hpPercent = hpPercent;
        this.borderColor = addHp ? Colors.WHITE.getColor() : Colors.BORDER_COLOR.getColor();
        if (!showBandaged) {
            if (hpPercent > 1.0f) {
                this.setColor(Colors.ADDITIONAL_HEALTH_COLOR.getColor());
            } else if (hpPercent == 1.0f) {
                this.setColor(Colors.FULL_HEALTH_COLOR.getColor());
            } else if (hpPercent >= 0.9f) {
                this.setColor(Colors.LITTLE_DAMAGED_HEALTH_COLOR.getColor());
            } else if (hpPercent >= 0.75f) {
                this.setColor(Colors.DAMAGED_HEALTH_COLOR.getColor());
            } else if (hpPercent >= 0.5f) {
                this.setColor(Colors.HALF_HEALTH_COLOR.getColor());
            } else if (hpPercent >= 0.25f) {
                this.setColor(Colors.VERY_DAMAGED_HEALTH_COLOR.getColor());
            } else if (hpPercent > 0.0f) {
                this.setColor(Colors.VERY_VERY_DAMAGED_HEALTH_COLOR.getColor());
            } else {
                this.setColor(Colors.NULL_HEALTH_COLOR.getColor());
            }
        } else {
            this.setColor(Colors.BANDAGED_BODY_PART.getColor());
        }
    }

    public float getHpPercent() {
        return this.hpPercent;
    }

    public static void renderAllParts(class_332 context, float tickDelta, Vector2f pos) {
        for (BodyPartHud part : BodyPartHud.values()) {
            part.renderPart(context, tickDelta, pos);
        }
    }

    public static void renderAllParts(class_332 context, float tickDelta) {
        BodyPartHud.renderAllParts(context, tickDelta, POS);
    }

    public static void setPos(Vector2f pos) {
        POS = pos;
    }

    public static Vector2f getPos() {
        return POS;
    }

    public static int getWidth() {
        return 35;
    }

    public static int getHeight() {
        return 73;
    }

    static {
        POS = new Vector2f((float)ConfigKeys.HEALTH_HUD_X.getValue().intValue(), (float)ConfigKeys.HEALTH_HUD_Y.getValue().intValue());
    }

    public static enum Colors {
        BANDAGED_BODY_PART(-1648211),
        ADDITIONAL_HEALTH_COLOR(-16384240),
        FULL_HEALTH_COLOR(-13338066),
        LITTLE_DAMAGED_HEALTH_COLOR(-3612672),
        DAMAGED_HEALTH_COLOR(-2053632),
        HALF_HEALTH_COLOR(-2064384),
        VERY_DAMAGED_HEALTH_COLOR(-2080256),
        VERY_VERY_DAMAGED_HEALTH_COLOR(0xFF00000),
        NULL_HEALTH_COLOR(-12434878),
        WHITE(-1),
        BORDER_COLOR(-15592942);

        private final int color;

        private Colors(int color) {
            this.color = color;
        }

        int getColor() {
            return this.color;
        }
    }
}

