/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player;

import aiven.zomboidhealthsystem.ConfigKeys;
import aiven.zomboidhealthsystem.ModDamageTypes;
import aiven.zomboidhealthsystem.ZomboidHealthSystem;
import aiven.zomboidhealthsystem.foundation.items.BandageItem;
import aiven.zomboidhealthsystem.foundation.player.HungerHelper;
import aiven.zomboidhealthsystem.foundation.player.conditions.Cold;
import aiven.zomboidhealthsystem.foundation.player.conditions.Condition;
import aiven.zomboidhealthsystem.foundation.player.conditions.Drowsiness;
import aiven.zomboidhealthsystem.foundation.player.conditions.Exhaustion;
import aiven.zomboidhealthsystem.foundation.player.conditions.Pain;
import aiven.zomboidhealthsystem.foundation.player.conditions.Temperature;
import aiven.zomboidhealthsystem.foundation.player.conditions.Thirst;
import aiven.zomboidhealthsystem.foundation.player.conditions.Wet;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import aiven.zomboidhealthsystem.infrastructure.config.JsonBuilder;
import aiven.zomboidhealthsystem.infrastructure.config.JsonConfig;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public final class Health {
    private static final int HEAD_CHANCE_HIT = 24;
    private static final int BODY_CHANCE_HIT = 30;
    private static final int ARMS_CHANCE_HIT = 28;
    private static final int LEGS_CHANCE_HIT = 16;
    private static final int FOOTS_CHANCE_HIT = 2;
    public static final String HEAD_ID = "head";
    public static final String BODY_ID = "body";
    public static final String LEFT_ARM_ID = "left_arm";
    public static final String RIGHT_ARM_ID = "right_arm";
    public static final String LEFT_LEG_ID = "left_leg";
    public static final String RIGHT_LEG_ID = "right_leg";
    public static final String LEFT_FOOT_ID = "left_foot";
    public static final String RIGHT_FOOT_ID = "right_foot";
    public static final int MAX_HEAD_HP = 4;
    public static final int MAX_BODY_HP = 6;
    public static final int MAX_ARM_HP = 4;
    public static final int MAX_LEG_HP = 4;
    public static final int MAX_FOOT_HP = 4;
    public static final int BANDAGE_HEAL_TIME = ConfigKeys.HEAL_TIME.getValue();
    public static final int BANDAGE_BECOME_DIRTY_AFTER = 2400;
    public static final int UPDATE_FREQUENCY = ZomboidHealthSystem.UPDATE_FREQUENCY;
    public static final int INFECTION_TIME = ConfigKeys.INFECTION_TIME.getValue();
    public static final int MAX_SLOWNESS_AMPLIFIER = 4;
    public static final int PLAYER_FALLING_IF_AMPLIFIER = 4;
    private final class_1657 user;
    private final Head head;
    private final Body body;
    private final Arm leftArm;
    private final Arm rightArm;
    private final Leg leftLeg;
    private final Leg rightLeg;
    private final Foot leftFoot;
    private final Foot rightFoot;
    private final BodyPart[] bodyParts;
    private final Pain pain;
    private final Drowsiness drowsiness;
    private final Thirst thirst;
    private final Exhaustion exhaustion;
    private final Cold cold;
    private final Wet wet;
    private final Condition[] conditions;
    private final HungerHelper hunger;
    private final Temperature temperature;
    private boolean isDead = false;
    private float playerHp = 100.0f;
    private boolean isCanWalk = true;
    private int i = 0;

    public Health(class_1657 user) {
        this(user, 4.0f, 6.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f);
    }

    public Health(class_1657 user, float headHp, float bodyHp, float leftArmHp, float rightArmHp, float leftLegHp, float rightLegHp, float leftFootHp, float rightFootHp) {
        this.user = user;
        this.head = new Head(this, headHp, user);
        this.body = new Body(this, bodyHp, user);
        this.leftArm = new Arm(this, leftArmHp, user, LEFT_ARM_ID);
        this.rightArm = new Arm(this, rightArmHp, user, RIGHT_ARM_ID);
        this.leftLeg = new Leg(this, leftLegHp, user, LEFT_LEG_ID);
        this.rightLeg = new Leg(this, rightLegHp, user, RIGHT_LEG_ID);
        this.leftFoot = new Foot(this, leftFootHp, user, LEFT_FOOT_ID);
        this.rightFoot = new Foot(this, rightFootHp, user, RIGHT_FOOT_ID);
        this.bodyParts = new BodyPart[]{this.head, this.body, this.leftArm, this.rightArm, this.leftLeg, this.rightLeg, this.leftFoot, this.rightFoot};
        this.pain = new Pain(this);
        this.drowsiness = new Drowsiness(this);
        this.thirst = new Thirst(this);
        this.exhaustion = new Exhaustion(this);
        this.temperature = new Temperature(this);
        this.cold = new Cold(this);
        this.wet = new Wet(this);
        this.hunger = new HungerHelper(this);
        this.conditions = new Condition[]{this.pain, this.drowsiness, this.thirst, this.exhaustion, this.temperature, this.cold, this.wet};
    }

    public void tick() {
        if (this.i++ >= UPDATE_FREQUENCY - 1) {
            this.update();
            this.i = 0;
        }
    }

    public void applyEffects() {
        if (this.getPlayer().method_5805() && !this.getPlayer().method_7337()) {
            Effects effects = new Effects();
            for (BodyPart part : this.bodyParts) {
                part.addEffectAmplifier(effects);
            }
            if (effects.slownessAmplifier >= 4.0f) {
                this.getPlayer().method_18380(class_4050.field_18079);
                this.isCanWalk = false;
            } else {
                this.isCanWalk = true;
            }
            if (effects.slownessAmplifier > 4.0f) {
                effects.slownessAmplifier = 4.0f;
            }
            this.addStatusEffect(class_1294.field_5909, (int)effects.slownessAmplifier, 300);
            this.addStatusEffect(class_1294.field_5901, (int)effects.fatigueAmplifier, 300);
            this.addStatusEffect(class_1294.field_5911, (int)effects.fatigueAmplifier, 300);
            if (this.getPlayerHp() <= 0.0f) {
                this.onDeath(Util.getDamageSource(ModDamageTypes.BLEEDING, this.getPlayer().method_37908()));
            }
            this.getPain().applyEffects();
        }
    }

    public void update() {
        if (this.getPlayer().method_5805() && !this.getPlayer().method_7337() && !this.getPlayer().method_7325()) {
            for (BodyPart part : this.bodyParts) {
                part.update();
            }
            this.applyEffects();
            if (this.getPlayer().method_6059(class_1294.field_5924)) {
                int amplifier = this.getPlayer().method_6112(class_1294.field_5924).method_5578();
                this.healAllParts(((float)amplifier + 1.0f) / 100.0f * (float)UPDATE_FREQUENCY);
                this.healPlayerHp(((float)amplifier + 1.0f) / 100.0f * (float)UPDATE_FREQUENCY);
            }
            if (!this.getPlayer().method_6059(class_1294.field_5898)) {
                for (BodyPart bodyPart : this.bodyParts) {
                    bodyPart.setAdditionalHp(0.0f);
                }
            }
            if (this.getPlayer().method_7344().method_7586() >= 19 && !this.haveInfection()) {
                this.healPlayerHp(0.003f * (float)UPDATE_FREQUENCY);
            }
            for (Condition condition : this.conditions) {
                condition.update();
            }
            this.getHunger().update();
        }
    }

    public void damage(class_1282 source, float amount) {
        float damageAmount = (float)Util.floor(amount, 10);
        this.getPlayer().method_6066().method_5547(source, amount);
        if (damageAmount < 0.0f) {
            return;
        }
        if (this.getPlayer().method_5805() && this.isAlive()) {
            if (source.method_49708(class_8111.field_44869)) {
                this.onDeath(source);
            } else if (source.method_49708(class_8111.field_42342)) {
                this.damagePlayerHp(source, amount * 5.0f);
                if (this.getPlayerHp() <= 0.0f) {
                    this.onDeath(source);
                }
            } else if (Health.isPointDamage(source)) {
                float d = this.randomHit().damage(damageAmount);
                if (d > 0.1f && this.importantBodyPartsAlive(source)) {
                    this.damage(source, d);
                }
            } else if (source.method_49708(class_8111.field_42345) || source.method_49708(class_8111.field_42339) && this.getPlayer().method_18376() != class_4050.field_18079) {
                BodyPart[] orderDamageBodyParts = new BodyPart[]{this.head, this.leftArm, this.rightArm, this.body, this.leftLeg, this.rightLeg, this.leftFoot, this.rightFoot};
                float d = damageAmount / 2.0f;
                for (int i = 7; i != 0 && !(d < 0.2f); --i) {
                    int random = new Random().nextInt(0, 2);
                    BodyPart part = orderDamageBodyParts[i - random];
                    d = part.damage(d, 0.75f);
                }
            } else if (Health.isAllBodyDamage(source)) {
                for (BodyPart part : this.bodyParts) {
                    part.damage(damageAmount / (float)this.alivePartCount(), 0.75f);
                }
                this.importantBodyPartsAlive(source);
            } else {
                int random = new Random().nextInt(0, 8);
                float d = this.bodyParts[random].damage(amount);
                if (d > 0.2f && this.importantBodyPartsAlive(source)) {
                    this.damage(source, d);
                }
            }
            this.applyEffects();
        }
    }

    private void damagePlayerHp(class_1282 source, float amount) {
        this.getPlayer().method_6066().method_5547(source, amount);
        if (amount > 0.0f) {
            this.setPlayerHp(Math.max(this.getPlayerHp() - amount, 0.0f));
        }
    }

    public void healPlayerHp(float amount) {
        this.setPlayerHp(Math.min(100.0f, this.getPlayerHp() + amount));
    }

    public void healRandom(float amount) {
        int random;
        float d;
        if (!this.isFullHp() && (d = this.bodyParts[random = new Random().nextInt(0, 8)].heal(amount)) > 0.1f) {
            this.healRandom(d);
        }
    }

    public void healAllParts(float amount) {
        int i = 8;
        for (BodyPart part : this.bodyParts) {
            if (!part.isFullHp()) continue;
            --i;
        }
        if (i != 0) {
            for (BodyPart part : this.bodyParts) {
                part.heal(amount / (float)i);
            }
        }
    }

    public Pain getPain() {
        return this.pain;
    }

    public Drowsiness getDrowsiness() {
        return this.drowsiness;
    }

    public Thirst getThirst() {
        return this.thirst;
    }

    public Exhaustion getExhaustion() {
        return this.exhaustion;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public Cold getCold() {
        return this.cold;
    }

    public HungerHelper getHunger() {
        return this.hunger;
    }

    public Wet getWet() {
        return this.wet;
    }

    public void stumble(float damage) {
        if (!this.getPlayer().method_20448()) {
            int random = new Random().nextInt(6, 8);
            if (damage != 0.0f) {
                this.bodyParts[random].damage(damage, 0.0f);
            }
            this.getPlayer().method_18380(class_4050.field_18079);
            ModServer.getInstance().sendPacketDamage(this.getPlayer());
            this.getPlayer().method_37908().method_45447(null, this.getPlayer().method_24515(), class_3417.field_14904, class_3419.field_15254);
            this.addStatusEffect(class_1294.field_5919, 1, 60);
        }
    }

    public void stumble() {
        this.stumble(0.05f);
    }

    public void onSleep() {
        this.getTemperature().onSleep();
        this.getHunger().onSleep();
        for (Condition condition : this.conditions) {
            condition.onSleep();
        }
        for (BodyPart part : this.bodyParts) {
            part.onSleep();
        }
    }

    public boolean importantBodyPartsAlive(class_1282 source) {
        boolean bl;
        boolean bl2 = bl = this.head.getHp() <= 0.0f || this.body.getHp() <= 0.0f;
        if (bl && this.isAlive()) {
            this.onDeath(source);
        }
        return bl;
    }

    public float getSumHp() {
        float sum = 0.0f;
        for (BodyPart part : this.bodyParts) {
            sum += part.getHp();
        }
        return sum;
    }

    public float getSumBleeding() {
        float sum = 0.0f;
        for (BodyPart part : this.bodyParts) {
            sum += part.getBleeding();
        }
        return sum;
    }

    public int alivePartCount() {
        int count = 0;
        for (BodyPart part : this.bodyParts) {
            if (!(part.getHp() > 0.0f)) continue;
            ++count;
        }
        return count;
    }

    public float getMaxSumHp() {
        float d = 0.0f;
        for (BodyPart part : this.bodyParts) {
            d += part.getMaxHp();
        }
        return d;
    }

    public float getBodyHpPercent() {
        return this.getSumHp() / this.getMaxSumHp();
    }

    public void onDeath(class_1282 source) {
        if (this.isAlive()) {
            if (source != null) {
                this.getPlayer().method_6066().method_5547(source, 0.0f);
            }
            this.isDead = true;
            this.getPlayer().method_6033(0.0f);
            this.getPlayer().method_6078(source);
        }
    }

    public boolean isFullHp() {
        for (BodyPart part : this.bodyParts) {
            if (part.isFullHp()) continue;
            return false;
        }
        return true;
    }

    public class_1657 getPlayer() {
        return this.user;
    }

    public float getPlayerHp() {
        return this.playerHp;
    }

    public boolean isAlive() {
        return !this.isDead && this.getPlayer().method_5805();
    }

    public boolean isCanWalk() {
        return this.isCanWalk;
    }

    public void setPlayerHp(float playerHp) {
        this.playerHp = playerHp;
    }

    public BodyPart[] getBodyParts() {
        return this.bodyParts;
    }

    public boolean haveInfection() {
        for (BodyPart part : this.bodyParts) {
            if (!part.isInfection()) continue;
            return true;
        }
        return false;
    }

    public BodyPart randomHit() {
        int random = new Random().nextInt(0, 101);
        if (random <= 24) {
            return this.head;
        }
        if (random <= 54) {
            return this.body;
        }
        if (random <= 68) {
            return this.leftArm;
        }
        if (random <= 82) {
            return this.rightArm;
        }
        if (random <= 90) {
            return this.leftLeg;
        }
        if (random <= 98) {
            return this.rightLeg;
        }
        if (random <= 99) {
            return this.leftFoot;
        }
        return this.rightFoot;
    }

    public void clearEffect(class_1291 effect) {
        if (this.getPlayer().method_6059(effect)) {
            this.getPlayer().method_6016(effect);
        }
    }

    public void addStatusEffect(class_1291 effect, int amplifier, int duration) {
        Util.addStatusEffect(this.getPlayer(), effect, duration, amplifier);
    }

    public BodyPart getBodyPart(String id) {
        for (BodyPart part : this.bodyParts) {
            if (!part.getId().equals(id)) continue;
            return part;
        }
        return null;
    }

    public String toString() {
        JsonBuilder healthBuilder = new JsonBuilder();
        if (this.getPlayerHp() != 100.0f) {
            healthBuilder.append("player_hp", String.valueOf(this.playerHp));
        }
        for (Condition condition : this.conditions) {
            String value = condition.getNbt();
            if (value == null) continue;
            healthBuilder.append(condition.getId(), value);
        }
        for (BodyPart part : this.bodyParts) {
            JsonBuilder bodyPartBuilder = new JsonBuilder();
            if (part.getHp() != part.getMaxHp()) {
                bodyPartBuilder.append("hp", String.valueOf(part.getHp()));
            }
            if (part.getAdditionalHp() > 0.0f) {
                bodyPartBuilder.append("add_hp", String.valueOf(part.getAdditionalHp()));
            }
            if (part.isBandaged()) {
                bodyPartBuilder.append("bandage_time", String.valueOf(part.getBandageTime()));
                bodyPartBuilder.append("bandage_item", String.valueOf(class_1792.method_7880((class_1792)part.getBandageItem())));
            }
            if (part.isBleeding()) {
                bodyPartBuilder.append("bleeding", String.valueOf(part.getBleeding()));
            }
            if (part.getInfection() > 0) {
                bodyPartBuilder.append("infection", String.valueOf(part.getInfection()));
            }
            if (bodyPartBuilder.isEmpty()) continue;
            healthBuilder.append(part.getId(), bodyPartBuilder.get());
        }
        return healthBuilder.get();
    }

    public static Health parseHealth(class_1657 user, String value) {
        String player_hp;
        Health health = new Health(user);
        for (int i = 0; i < 8; ++i) {
            BodyPart bodyPart = health.getBodyParts()[i];
            String bodyPartValue = JsonConfig.getValue(value, bodyPart.getId());
            if (bodyPartValue == null) continue;
            Health.parseBodyPart(bodyPartValue, bodyPart);
        }
        for (Condition condition : health.conditions) {
            String conditionValue = JsonConfig.getValue(value, condition.getId());
            if (conditionValue == null) continue;
            condition.readNbt(conditionValue);
        }
        if (health.head.getHp() == 0.0f || health.body.getHp() == 0.0f) {
            health.isDead = true;
        }
        if ((player_hp = JsonConfig.getValue(value, "player_hp")) != null) {
            health.setPlayerHp(Float.parseFloat(player_hp));
        } else {
            health.setPlayerHp(100.0f);
        }
        return health;
    }

    private static void parseBodyPart(String value, BodyPart bodyPart) {
        String infection;
        String bleeding;
        String addHp;
        String hp = JsonConfig.getValue(value, "hp");
        if (hp != null) {
            bodyPart.setHp(Float.parseFloat(hp));
        }
        if ((addHp = JsonConfig.getValue(value, "add_hp")) != null) {
            bodyPart.setAdditionalHp(Float.parseFloat(addHp));
        }
        String bandage_item = JsonConfig.getValue(value, "bandage_item");
        String bandage_time = JsonConfig.getValue(value, "bandage_time");
        if (bandage_item != null && bandage_time != null) {
            bodyPart.setBandageItem((BandageItem)class_1792.method_7875((int)Integer.parseInt(bandage_item)));
            bodyPart.setBandageTime(Integer.parseInt(bandage_time));
        }
        if ((bleeding = JsonConfig.getValue(value, "bleeding")) != null) {
            bodyPart.setBleeding(Float.parseFloat(bleeding));
        }
        if ((infection = JsonConfig.getValue(value, "infection")) != null) {
            bodyPart.setInfection(Integer.parseInt(infection));
        }
    }

    private static boolean isAllBodyDamage(class_1282 source) {
        for (class_6862 class_68622 : new class_6862[]{class_8103.field_42249, class_8103.field_42243, class_8103.field_42246, class_8103.field_42252, class_8103.field_42253}) {
            if (!source.method_48789(class_68622)) continue;
            return true;
        }
        for (class_6862 class_68623 : new class_5321[]{class_8111.field_42349}) {
            if (!source.method_49708((class_5321)class_68623)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPointDamage(class_1282 source) {
        for (class_5321 t : new class_5321[]{class_8111.field_42321, class_8111.field_42360, class_8111.field_42323, class_8111.field_42319, class_8111.field_42344, class_8111.field_42320, class_8111.field_42325}) {
            if (!source.method_49708(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean random(int time) {
        return new Random().nextInt(0, time / UPDATE_FREQUENCY) == 0;
    }

    private static class Head
    extends ImportartBodyPart {
        private Head(Health health, float hp, class_1657 user) {
            super(health, hp, user, Health.HEAD_ID);
        }

        @Override
        protected void wasDamaged(float amount) {
            if (amount >= 1.0f) {
                Util.addStatusEffect(this.getPlayer(), class_1294.field_5919, 200, 1);
                this.getHealth().damagePlayerHp(new class_1282((class_6880)this.getPlayer().method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(ModDamageTypes.BLEEDING)), amount * 5.0f);
            }
        }

        @Override
        protected void addEffectAmplifier(Effects effects) {
        }

        @Override
        public float getMaxHp() {
            return 4.0f;
        }

        @Override
        public void update() {
            super.update();
            if (this.getMaxHp() / 2.0f >= this.getHp() && Health.random(3600)) {
                Util.addStatusEffect(this.getPlayer(), class_1294.field_5919, 200, 1);
            }
        }
    }

    private static class Body
    extends ImportartBodyPart {
        private Body(Health health, float hp, class_1657 user) {
            super(health, hp, user, Health.BODY_ID);
        }

        @Override
        protected void wasDamaged(float amount) {
            if (amount >= 1.0f) {
                this.getHealth().damagePlayerHp(new class_1282((class_6880)this.getPlayer().method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(ModDamageTypes.BLEEDING)), amount * 5.0f);
            }
        }

        @Override
        protected void addEffectAmplifier(Effects effects) {
            effects.slownessAmplifier += (this.getMaxHp() - this.getHp()) / 2.0f;
        }

        @Override
        public float getMaxHp() {
            return 6.0f;
        }

        @Override
        public void update() {
            super.update();
            if (this.getMaxHp() / 2.0f >= this.getHp() && Health.random(3600)) {
                Util.addStatusEffect(this.getPlayer(), class_1294.field_5916, 200, 1);
            }
        }
    }

    private static class Arm
    extends BodyPart {
        private Arm(Health health, float hp, class_1657 user, String name) {
            super(health, hp, user, name);
        }

        @Override
        protected void addEffectAmplifier(Effects effects) {
            effects.fatigueAmplifier += (this.getMaxHp() - this.getHp()) / 3.0f;
        }

        @Override
        public float getMaxHp() {
            return 4.0f;
        }
    }

    private static class Leg
    extends BodyPart {
        private Leg(Health health, float hp, class_1657 user, String name) {
            super(health, hp, user, name);
        }

        @Override
        protected void addEffectAmplifier(Effects effects) {
            effects.slownessAmplifier += (this.getMaxHp() - this.getHp()) / 2.0f;
        }

        @Override
        public float getMaxHp() {
            return 4.0f;
        }
    }

    private static class Foot
    extends BodyPart {
        private Foot(Health health, float hp, class_1657 user, String name) {
            super(health, hp, user, name);
        }

        @Override
        protected void addEffectAmplifier(Effects effects) {
            effects.slownessAmplifier += (this.getMaxHp() - this.getHp()) / 2.0f;
        }

        @Override
        public float getMaxHp() {
            return 4.0f;
        }
    }

    public static abstract class BodyPart {
        private final Health health;
        private float hp;
        private float additionalHp;
        private final class_1657 player;
        private final String id;
        private int bandageTime = 0;
        private BandageItem bandageItem;
        private BandageItem lastBandageItem;
        private float bleeding = 0.0f;
        private int infection = 0;

        private BodyPart(Health health, float hp, class_1657 player, String id) {
            this.health = health;
            this.hp = hp;
            this.player = player;
            this.id = id;
        }

        public float heal(float amount) {
            if (!this.isFullHp()) {
                if (this.getHp() + amount > this.getMaxHp()) {
                    float d = this.getHp() + amount - this.getMaxHp();
                    this.setHp(this.getMaxHp());
                    return d;
                }
                this.setHp(this.getHp() + amount);
                return 0.0f;
            }
            return amount;
        }

        public float damage(float amount, float bleeding_chance) {
            float g;
            float random;
            float d;
            if (this.getAdditionalHp() > 0.0f) {
                d = amount - this.additionalHp;
                this.setAdditionalHp(Math.max(0.0f, this.additionalHp - amount));
                amount = d;
            }
            if (amount <= 0.0f) {
                return 0.0f;
            }
            if (amount > this.getHp()) {
                d = amount - this.hp;
                this.setHp(0.0f);
                this.setBleeding(2.5f);
                this.getHealth().damagePlayerHp(Util.getDamageSource(ModDamageTypes.BLEEDING, this.getHealth().getPlayer().method_37908()), amount - d);
                return d;
            }
            this.hp -= amount;
            if (bleeding_chance > 0.0f && (random = new Random().nextFloat(0.0f, g = 13.0f / ((this.getMaxHp() - this.getHp()) * bleeding_chance))) <= 5.0f) {
                this.setBleeding((this.getMaxHp() - this.getHp()) / 2.0f);
            }
            return 0.0f;
        }

        public float damage(float amount) {
            return this.damage(amount, 1.0f);
        }

        protected void update() {
            this.checkInfect();
            if (this.getHp() >= this.getMaxHp()) {
                this.setBleeding(0.0f);
            }
            if (this.isBandaged()) {
                if (!this.isInfection()) {
                    this.heal(this.bandageItem.getHealAmount() / (float)BANDAGE_HEAL_TIME * ((float)this.getPlayer().method_7344().method_7586() / 20.0f) * (float)UPDATE_FREQUENCY);
                }
                this.setBandageTime(this.getBandageTime() + UPDATE_FREQUENCY);
                if (this.bandageItem.isDirty()) {
                    this.addInfection(UPDATE_FREQUENCY);
                }
                if (this.bandageItem.isStopBleeding()) {
                    if (this.isBleeding()) {
                        this.setBleeding(this.getBleeding() - 1.5E-4f * (float)UPDATE_FREQUENCY);
                        if ((double)this.getBandageTime() > 2400.0 / ((double)this.getBleeding() + 0.5) / (double)this.bandageItem.dirtyDivisor()) {
                            this.setBandageItem(this.bandageItem.getDirtyBandageItem());
                        }
                    }
                } else {
                    this.getHealth().damagePlayerHp(Util.getDamageSource(ModDamageTypes.BLEEDING, this.getPlayer().method_37908()), this.getBleeding() / 30.0f * (float)UPDATE_FREQUENCY);
                }
            } else {
                this.getHealth().damagePlayerHp(Util.getDamageSource(ModDamageTypes.BLEEDING, this.getPlayer().method_37908()), this.getBleeding() / 30.0f * (float)UPDATE_FREQUENCY);
            }
        }

        private void checkInfect() {
            if (this.isInfection()) {
                this.setInfection(this.getInfection() + UPDATE_FREQUENCY);
                if (this.getInfection() > INFECTION_TIME * 2) {
                    this.getHealth().addStatusEffect(class_1294.field_5909, 1, 300);
                    if (this.getInfection() > INFECTION_TIME * 3) {
                        this.getHealth().addStatusEffect(class_1294.field_5901, 1, 300);
                        if (this.getInfection() > INFECTION_TIME * 4) {
                            this.getHealth().addStatusEffect(class_1294.field_5909, 2, 300);
                            this.getHealth().addStatusEffect(class_1294.field_5911, 1, 300);
                            if (this.getInfection() > INFECTION_TIME * 5) {
                                if (Health.random(2400)) {
                                    this.getHealth().stumble(0.0f);
                                }
                                if (Health.random(400)) {
                                    this.getHealth().addStatusEffect(class_1294.field_5916, 1, 140);
                                }
                                if (this.getInfection() > INFECTION_TIME * 6) {
                                    if (Health.random(2400)) {
                                        this.getHealth().stumble(0.0f);
                                    }
                                    if (Health.random(400)) {
                                        this.getHealth().addStatusEffect(class_1294.field_5919, 1, 140);
                                    }
                                    if (this.getInfection() > INFECTION_TIME * 7) {
                                        this.getHealth().addStatusEffect(class_1294.field_5899, 1, 300);
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (this.getHp() >= this.getMaxHp()) {
                this.addInfection(-UPDATE_FREQUENCY);
            }
        }

        public void bandage(BandageItem item) {
            this.bandageTime = 0;
            this.bandageItem = item;
            this.lastBandageItem = null;
        }

        public class_1792 unBandage() {
            this.bandageTime = 0;
            if (this.bandageItem != null) {
                this.lastBandageItem = this.bandageItem;
                this.bandageItem = null;
                return this.lastBandageItem;
            }
            return null;
        }

        public class_1792 getBandageItem() {
            return this.bandageItem;
        }

        private void setBandageItem(@Nullable BandageItem item) {
            this.bandageItem = item;
        }

        private void setBandageTime(int bandageTime) {
            this.bandageTime = Math.max(bandageTime, 0);
        }

        public int getBandageTime() {
            return this.bandageTime;
        }

        public boolean isBandaged() {
            return this.bandageItem != null;
        }

        public float getBleeding() {
            return this.bleeding;
        }

        public void setBleeding(float bleeding) {
            this.bleeding = Math.max(bleeding, 0.0f);
        }

        public boolean isBleeding() {
            return this.getBleeding() != 0.0f;
        }

        public boolean isInfection() {
            return this.getInfection() > INFECTION_TIME;
        }

        public void setInfection(int infection) {
            this.infection = Math.max(infection, 0);
        }

        public void addInfection(int infection) {
            this.setInfection(this.getInfection() + infection);
        }

        public int getInfection() {
            return this.infection;
        }

        public void disInfect() {
            this.setInfection(this.getInfection() - INFECTION_TIME / 5);
            if (!this.isInfection()) {
                this.setInfection(0);
            }
        }

        protected void onSleep() {
            this.heal(0.5f);
            if (this.isBandaged()) {
                this.setBleeding(this.getBleeding() - 0.3f);
            }
        }

        public Health getHealth() {
            return this.health;
        }

        public float getHp() {
            return this.hp;
        }

        public void setHp(float hp) {
            this.hp = hp;
        }

        public void setAdditionalHp(float additionalHp) {
            this.additionalHp = additionalHp;
        }

        public float getAdditionalHp() {
            return this.additionalHp;
        }

        public class_1657 getPlayer() {
            return this.player;
        }

        public String getId() {
            return this.id;
        }

        public boolean isFullHp() {
            return this.getHp() >= this.getMaxHp();
        }

        public float getPain() {
            if (this.getHp() <= 0.2f) {
                return 5.0f;
            }
            float d = this.getMaxHp() - this.getHp();
            if (this.isBandaged()) {
                return d / 1.25f;
            }
            return d;
        }

        protected abstract void addEffectAmplifier(Effects var1);

        public abstract float getMaxHp();
    }

    private static class Effects {
        public float slownessAmplifier = 0.0f;
        public float fatigueAmplifier = 0.0f;

        private Effects() {
        }
    }

    private static abstract class ImportartBodyPart
    extends BodyPart {
        private ImportartBodyPart(Health health, float hp, class_1657 user, String name) {
            super(health, hp, user, name);
        }

        protected void nullHp() {
            this.getHealth().onDeath(new class_1282((class_6880)this.getPlayer().method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(ModDamageTypes.SEVERE_DAMAGE)));
        }

        @Override
        public void update() {
            super.update();
            if (this.getHp() == 0.0f) {
                this.nullHp();
            }
        }

        @Override
        public float damage(float amount) {
            this.wasDamaged(amount);
            return super.damage(amount);
        }

        protected abstract void wasDamaged(float var1);
    }
}

