/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.ConfigKeys;
import aiven.zomboidhealthsystem.ModDamageTypes;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.player.conditions.Condition;
import aiven.zomboidhealthsystem.foundation.player.conditions.Temperature;
import aiven.zomboidhealthsystem.foundation.player.conditions.Wet;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1294;

public class Cold
extends Condition {
    private final class_1282 source = Util.getDamageSource(ModDamageTypes.COLD, this.getPlayer().method_37908());

    public Cold(Health health) {
        super(health);
    }

    @Override
    class_1291 getEffect() {
        return ModStatusEffects.COLD;
    }

    @Override
    public String getId() {
        return "cold";
    }

    @Override
    public void setAmount(float amount) {
        this.amount = amount > 0.0f ? amount : 0.0f;
    }

    @Override
    public void update() {
        super.update();
        float bodyTemperature = this.getHealth().getTemperature().getAmount();
        float wet = this.getHealth().getWet().getAmount() / 2.0f + 1.0f;
        float d = Math.max((float)Math.sqrt(35.0f - bodyTemperature), 1.0f);
        if (bodyTemperature < 35.0f && this.getAmount() < 1.0f) {
            this.addAmount(1.6666666E-4f * d * wet * ConfigKeys.COLD_MULTIPLIER.getValue().floatValue() * (float)Health.UPDATE_FREQUENCY);
        }
        if (this.getAmount() >= 1.0f) {
            if (bodyTemperature < 35.0f) {
                this.addAmount(5.5555556E-5f * d * wet * ConfigKeys.COLD_MULTIPLIER.getValue().floatValue() * (float)Health.UPDATE_FREQUENCY);
            }
            this.getHealth().getExhaustion().addMultiplier(Float.valueOf(this.getAmount()));
            this.getHealth().getDrowsiness().addTicks(this.getAmount() / 2.0f * (float)Health.UPDATE_FREQUENCY);
            this.getHealth().getThirst().addAmount(this.getAmount() / 24000.0f);
            if (this.getAmount() >= 2.5f) {
                if (this.random(1200)) {
                    this.getHealth().addStatusEffect(class_1294.field_5916, 1, 200);
                }
                if (this.getAmount() >= 3.1f) {
                    this.getHealth().onDeath(this.source);
                }
            }
        }
    }

    @Override
    public void onSleep() {
        Temperature temperature = this.getHealth().getTemperature();
        Wet wet = this.getHealth().getWet();
        float multiplier = wet.getAmount() / 2.0f + 1.0f;
        if (temperature.getAmount() < 35.0f) {
            this.addAmount(0.75f * multiplier);
        } else if (temperature.getAmount() > 36.0f) {
            this.addAmount(-0.5f / multiplier);
        }
    }
}

