/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.infrastructure.config;

import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.Config;
import aiven.zomboidhealthsystem.infrastructure.utility.FileHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class JsonConfig
implements Config {
    private final ArrayList<Codec<?>> codecs;
    private final File file;

    public JsonConfig(File file, boolean ignoreLastFile) throws IOException {
        this.file = Objects.requireNonNull(file);
        this.codecs = new ArrayList();
        if (!file.exists()) {
            throw new IOException("File not found: " + file);
        }
        if (!ignoreLastFile) {
            String[] names;
            String config = this.readConfig();
            for (String name : names = JsonConfig.getNames(config)) {
                this.codecs.add(new Codec<String>(name, JsonConfig.getValue(config, name)));
            }
        }
    }

    public JsonConfig(File file) throws IOException {
        this(file, false);
    }

    private String readConfig() throws IOException {
        return FileHelper.read(this.file);
    }

    private void writeInConfig(String text) throws IOException {
        FileHelper.write(this.file, text);
    }

    private Codec<?> getByName(String name) {
        for (Codec<?> codec : this.codecs) {
            if (!codec.getName().equals(name)) continue;
            return codec;
        }
        return null;
    }

    public void add(Codec<?> codec) {
        this.remove(codec.getName());
        this.codecs.add(codec);
    }

    public void remove(Codec<?> codec) {
        this.codecs.remove(codec);
    }

    public String getValue(Codec<?> codec) {
        Codec<?> codec1 = this.getByName(codec.getName());
        if (codec1 == null) {
            return null;
        }
        return codec1.getStringValue();
    }

    public Codec<?>[] getCodecs() {
        return this.codecs.toArray(new Codec[0]);
    }

    public File getFile() {
        return this.file;
    }

    public Integer getIntValue(String name) {
        String value = this.getValue(name);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public Float getFloatValue(String name) {
        String value = this.getValue(name);
        if (value != null) {
            return Float.valueOf(Float.parseFloat(value));
        }
        return null;
    }

    public Boolean getBooleanValue(String name) {
        String value = this.getValue(name);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    @Override
    public void save() throws IOException {
        StringBuilder content = new StringBuilder();
        content.append("{");
        for (int i = 0; i < this.codecs.size(); ++i) {
            Codec<?> codec = this.codecs.get(i);
            content.append("\n\t").append(JsonConfig.convertForConfig(codec.toString()));
            if (i == this.codecs.size() - 1) continue;
            content.append(",");
        }
        content.append("\n}");
        this.writeInConfig(content.toString());
    }

    @Override
    public String[] getNames() {
        String[] names = new String[this.codecs.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.codecs.get(i).getName();
        }
        return names;
    }

    @Override
    public void add(String name, String value) throws IOException {
        this.add(new Codec<String>(name, value));
    }

    @Override
    public boolean contains(String name) {
        return this.getByName(name) != null;
    }

    @Override
    public void remove(String name) {
        Codec<?> codec = this.getByName(name);
        if (codec != null) {
            this.codecs.remove(codec);
        }
    }

    @Override
    public String getValue(String name) {
        Codec<?> codec = this.getByName(name);
        if (codec == null) {
            return null;
        }
        return codec.getStringValue();
    }

    @Override
    public void clear() {
        this.codecs.clear();
    }

    public static String getValue(String config, String name) {
        String str;
        StringBuilder content = new StringBuilder(Objects.requireNonNull(config));
        int startIndex = content.indexOf(str = "\n\t\"" + name + "\": ");
        if (startIndex == -1) {
            return null;
        }
        int endIndex = content.indexOf(",\n\t\"", startIndex += str.length());
        if (endIndex == -1 && (endIndex = content.indexOf("\n}", startIndex)) == -1) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        for (int index = startIndex; index != endIndex; ++index) {
            value.append(content.charAt(index));
        }
        return JsonConfig.convertFromConfig(value.toString().trim());
    }

    public static String[] getNames(String config) {
        int index;
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder content = new StringBuilder(config);
        int lastIndex = 0;
        while ((index = content.indexOf("\n\t\"", lastIndex)) != -1) {
            char sym;
            lastIndex = (index += 3) + 1;
            StringBuilder name = new StringBuilder();
            while ((sym = content.charAt(index)) != '\"') {
                name.append(sym);
                ++index;
            }
            names.add(name.toString());
        }
        return names.toArray(new String[names.size()]);
    }

    private static String convertFromConfig(String value) {
        return value.replace("\n\t", "\n");
    }

    private static String convertForConfig(String codec) {
        return codec.replace("\n", "\n\t");
    }
}

