/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.infrastructure.utility;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class FileHelper {
    private FileHelper() {
    }

    public static ArrayList<File> getAllFiles(File folder) {
        ArrayList<File> files = new ArrayList<File>();
        if (folder != null && folder.listFiles() != null) {
            for (File file : folder.listFiles()) {
                if (file.isFile()) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                files.add(file);
                files.addAll(FileHelper.getAllFiles(file));
            }
        }
        return files;
    }

    public static boolean copy(File where, File folder) throws IOException {
        File file = new File(folder, where.getName());
        folder.mkdirs();
        FileHelper.write(file, FileHelper.read(where));
        return file.createNewFile();
    }

    public static void write(File file, String text) throws IOException {
        FileHelper.write(file, StandardCharsets.ISO_8859_1, text);
    }

    public static void write(File file, Charset encoding, String text) throws IOException {
        FileWriter fileWriter = new FileWriter(file, encoding);
        fileWriter.write(text);
        fileWriter.close();
    }

    public static String read(File file) throws IOException {
        return FileHelper.read(file, StandardCharsets.ISO_8859_1);
    }

    public static String read(File file, Charset encoding) throws IOException {
        int c;
        FileReader fileReader = new FileReader(file, encoding);
        StringBuilder text = new StringBuilder();
        while ((c = fileReader.read()) != -1) {
            text.append((char)c);
        }
        fileReader.close();
        return text.toString();
    }
}

