/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.client;

import aiven.zomboidhealthsystem.foundation.items.BandageItem;
import aiven.zomboidhealthsystem.infrastructure.config.JsonConfig;
import net.minecraft.class_1792;
import net.minecraft.class_2540;

public class ClientHealth {
    private final BodyPart head = new BodyPart(4.0f);
    private final BodyPart body = new BodyPart(6.0f);
    private final BodyPart leftArm = new BodyPart(4.0f);
    private final BodyPart rightArm = new BodyPart(4.0f);
    private final BodyPart leftLeg = new BodyPart(4.0f);
    private final BodyPart rightLeg = new BodyPart(4.0f);
    private final BodyPart leftFoot = new BodyPart(4.0f);
    private final BodyPart rightFoot = new BodyPart(4.0f);
    private final BodyPart[] bodyParts = new BodyPart[]{this.head, this.body, this.leftArm, this.rightArm, this.leftLeg, this.rightLeg, this.leftFoot, this.rightFoot};
    private float hp = 100.0f;

    public void onPacket(class_2540 packetByteBuf) {
        String health = packetByteBuf.method_19772();
        this.set(health);
    }

    private void set(String health) {
        String[] ids = new String[]{"head", "body", "left_arm", "right_arm", "left_leg", "right_leg", "left_foot", "right_foot"};
        String playerHp = JsonConfig.getValue(health, "player_hp");
        if (playerHp != null) {
            this.setHp(Float.parseFloat(playerHp));
        } else {
            this.setHp(100.0f);
        }
        for (int index = 0; index < ids.length; ++index) {
            String id = ids[index];
            String value = JsonConfig.getValue(health, id);
            BodyPart bodyPart = this.indexOf(index);
            if (value == null) {
                bodyPart.reset();
                continue;
            }
            String hpString = JsonConfig.getValue(value, "hp");
            if (hpString != null) {
                bodyPart.setHp(Float.parseFloat(hpString));
            } else {
                bodyPart.setHp(bodyPart.getMaxHp());
            }
            boolean stopBleeding = false;
            String bandageItemRawIdString = JsonConfig.getValue(value, "bandage_item");
            if (bandageItemRawIdString != null) {
                int rawId = Integer.parseInt(bandageItemRawIdString);
                class_1792 item = class_1792.method_7875((int)rawId);
                try {
                    BandageItem bandage = (BandageItem)item;
                    stopBleeding = bandage.isStopBleeding();
                    bodyPart.setBandaged(true);
                    bodyPart.setDirtyBandage(bandage.isDirty());
                }
                catch (Exception exception) {}
            } else {
                bodyPart.setBandaged(false);
                bodyPart.setDirtyBandage(false);
            }
            if (!stopBleeding) {
                String bleedingString = JsonConfig.getValue(value, "bleeding");
                bodyPart.setBleeding(bleedingString != null);
            } else {
                bodyPart.setBleeding(false);
            }
            String infection = JsonConfig.getValue(value, "infection");
            if (infection != null) {
                int ticks = Integer.parseInt(infection);
                bodyPart.setInfection(ticks > 6000);
                continue;
            }
            bodyPart.setInfection(false);
        }
    }

    public BodyPart indexOf(int index) {
        return this.bodyParts[index];
    }

    public void setHp(float hp) {
        this.hp = hp;
    }

    public float getHp() {
        return this.hp;
    }

    public float getSumHp() {
        float sum = 0.0f;
        for (BodyPart bodyPart : this.bodyParts) {
            sum += bodyPart.getHp();
        }
        return sum;
    }

    public float getMaxSumHp() {
        return 34.0f;
    }

    public float getSumHpPercent() {
        return this.getSumHp() / this.getMaxSumHp();
    }

    public BodyPart getBody() {
        return this.body;
    }

    public BodyPart getHead() {
        return this.head;
    }

    public BodyPart getLeftArm() {
        return this.leftArm;
    }

    public BodyPart getLeftFoot() {
        return this.leftFoot;
    }

    public BodyPart getLeftLeg() {
        return this.leftLeg;
    }

    public BodyPart getRightArm() {
        return this.rightArm;
    }

    public BodyPart getRightFoot() {
        return this.rightFoot;
    }

    public BodyPart getRightLeg() {
        return this.rightLeg;
    }

    public static class BodyPart {
        private float hp;
        private final float maxHp;
        boolean isBleeding = false;
        boolean isInfection = false;
        boolean isBandaged = false;
        boolean isDirtyBandage = false;

        public BodyPart(float maxHp) {
            this.maxHp = maxHp;
            this.hp = maxHp;
        }

        public void setInfection(boolean infection) {
            this.isInfection = infection;
        }

        public void setBleeding(boolean bleeding) {
            this.isBleeding = bleeding;
        }

        public void setBandaged(boolean bandaged) {
            this.isBandaged = bandaged;
        }

        public void setDirtyBandage(boolean dirtyBandage) {
            this.isDirtyBandage = dirtyBandage;
        }

        public boolean isBleeding() {
            return this.isBleeding;
        }

        public boolean isInfection() {
            return this.isInfection;
        }

        public boolean isBandaged() {
            return this.isBandaged;
        }

        public boolean isDirtyBandage() {
            return this.isDirtyBandage;
        }

        public float getMaxHp() {
            return this.maxHp;
        }

        public float getHp() {
            return this.hp;
        }

        public void setHp(float hp) {
            this.hp = hp;
        }

        public float getHpPercent() {
            return this.getHp() / this.getMaxHp();
        }

        public void reset() {
            this.setHp(this.maxHp);
            this.setBleeding(false);
            this.setInfection(false);
            this.setBandaged(false);
            this.setDirtyBandage(false);
        }
    }
}

