/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.player.conditions.Condition;
import aiven.zomboidhealthsystem.foundation.player.conditions.Temperature;
import java.util.ArrayList;
import net.minecraft.class_1291;
import net.minecraft.class_1294;

public class Exhaustion
extends Condition {
    private final ArrayList<Float> amplifiers = new ArrayList();

    public Exhaustion(Health health) {
        super(health);
    }

    @Override
    class_1291 getEffect() {
        return ModStatusEffects.EXHAUSTION;
    }

    @Override
    public String getId() {
        return "exhaustion";
    }

    @Override
    public void setAmount(float amount) {
        this.amount = Math.max(0.0f, amount);
    }

    @Override
    public void update() {
        super.update();
        float speed = this.getHealth().getPlayer().method_6029();
        if (speed > 0.1f) {
            this.addAmount(0.001f * ConfigArgs.EXHAUSTION_MULTIPLIER.getValue().floatValue() * this.getSumAmplifiers() * (float)Health.UPDATE_FREQUENCY);
        } else {
            this.addAmount(-0.001f * ConfigArgs.EXHAUSTION_MULTIPLIER.getValue().floatValue() * (float)Health.UPDATE_FREQUENCY);
        }
        if (this.amount > 1.5f) {
            this.getHealth().getWet().addAmount(0.002f * (float)Health.UPDATE_FREQUENCY);
            this.getHealth().addStatusEffect(class_1294.field_5909, (int)this.amount, 100);
            this.getHealth().addStatusEffect(class_1294.field_5901, (int)this.amount, 100);
        }
        Temperature temperature = this.getHealth().getTemperature();
        temperature.addHeat(this.getAmount() * 3.0f / (float)Temperature.UPDATE_MULTIPLIER);
        this.amplifiers.clear();
    }

    @Override
    public void onSleep() {
        this.setAmount(0.0f);
        this.amplifiers.clear();
    }

    public void addMultiplier(Float multiplier) {
        if (!this.amplifiers.contains(multiplier)) {
            this.amplifiers.add(multiplier);
        }
    }

    public float getSumAmplifiers() {
        float sum = 1.0f;
        for (float f : this.amplifiers) {
            sum += f - 1.0f;
        }
        return sum;
    }
}

