/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.world;

import aiven.zomboidhealthsystem.infrastructure.config.JsonBuilder;
import aiven.zomboidhealthsystem.infrastructure.config.JsonConfig;

public class WorldProperties {
    public static final WorldProperties DEFAULT = new WorldProperties(3, 28, 240000, true, true);
    int dayLengthMultiplier;
    int daysInSeason;
    int ticks;
    boolean temperature;
    boolean wind;

    public WorldProperties(int dayLengthMultiplier, int daysInSeason, int ticks, boolean temperature, boolean wind) {
        this.dayLengthMultiplier = dayLengthMultiplier;
        this.daysInSeason = daysInSeason;
        this.ticks = ticks;
        this.temperature = temperature;
        this.wind = wind;
    }

    public WorldProperties copy() {
        return new WorldProperties(this.getDayLengthMultiplier(), this.getDaysInSeason(), this.getTicks(), this.hasTemperature(), this.hasWind());
    }

    public void setDaysInSeason(int daysInSeason) {
        this.daysInSeason = daysInSeason;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public void setDayLengthMultiplier(int dayLengthMultiplier) {
        this.dayLengthMultiplier = dayLengthMultiplier;
    }

    public void setTemperature(boolean temperature) {
        this.temperature = temperature;
    }

    public void setWind(boolean wind) {
        this.wind = wind;
    }

    public int getDaysInSeason() {
        return this.daysInSeason;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getDayLengthMultiplier() {
        return this.dayLengthMultiplier;
    }

    public boolean hasTemperature() {
        return this.temperature;
    }

    public boolean hasWind() {
        return this.wind;
    }

    public String toString() {
        JsonBuilder builder = new JsonBuilder();
        builder.append("day length multiplier", String.valueOf(this.dayLengthMultiplier));
        builder.append("days in season", String.valueOf(this.daysInSeason));
        builder.append("ticks", String.valueOf(this.ticks));
        builder.append("temperature", String.valueOf(this.temperature));
        builder.append("wind", String.valueOf(this.wind));
        return builder.get();
    }

    private static int getInt(String value, int defaultValue) {
        try {
            int val = Integer.parseInt(value);
            return val;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static WorldProperties parseWorldProperties(String value) {
        String dayLengthString = JsonConfig.getValue(value, "day length multiplier");
        String daysInSeasonString = JsonConfig.getValue(value, "days in season");
        String ticksString = JsonConfig.getValue(value, "ticks");
        String temperatureString = JsonConfig.getValue(value, "temperature");
        String windString = JsonConfig.getValue(value, "wind");
        int dayLength = WorldProperties.getInt(dayLengthString, DEFAULT.getDayLengthMultiplier());
        int daysInSeason = WorldProperties.getInt(daysInSeasonString, DEFAULT.getDaysInSeason());
        int ticks = WorldProperties.getInt(ticksString, DEFAULT.getTicks());
        boolean temperature = temperatureString == null ? DEFAULT.hasTemperature() : Boolean.parseBoolean(temperatureString);
        boolean wind = windString == null ? DEFAULT.hasWind() : Boolean.parseBoolean(windString);
        return new WorldProperties(dayLength, daysInSeason, ticks, temperature, wind);
    }
}

