/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.client;

import aiven.zomboidhealthsystem.ZomboidHealthSystemClient;
import net.minecraft.class_2540;
import net.minecraft.class_638;

public class ClientWorldInfo {
    private int dayLengthMultiplier = 3;
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;
    private float temperature = 20.0f;
    private float worldTemp = 20.0f;
    private float seasonTemp = 20.0f;
    private float wind = 0.0f;
    private long ticksFromStart = 0L;

    public void onPacket(class_2540 packetByteBuf) {
        int[] temp = packetByteBuf.method_10787();
        boolean hasTemp = packetByteBuf.readBoolean();
        ClientWorldInfo worldInfo = ZomboidHealthSystemClient.WORLD_INFO;
        if (hasTemp) {
            worldInfo.setTemperature((float)temp[0] / 10.0f);
            worldInfo.setWorldTemp((float)temp[1] / 10.0f);
            worldInfo.setSeasonTemp((float)temp[2] / 10.0f);
            worldInfo.setWind((float)temp[3] / 10.0f);
        } else {
            worldInfo.setTemperature(0.0f);
            worldInfo.setWorldTemp(0.0f);
            worldInfo.setSeasonTemp(0.0f);
            worldInfo.setWind(0.0f);
        }
        this.setDayLengthMultiplier(temp[4]);
    }

    public void tick(class_638 world) {
        this.setSeconds((int)((float)world.method_8532() * 3.6f));
        this.setMinutes(this.getSeconds() / 60 % 60);
        this.setHours((this.getSeconds() / 3600 + 8) % 24);
        this.setTicksFromStart(world.method_8510());
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public void setDayLengthMultiplier(int dayLengthMultiplier) {
        this.dayLengthMultiplier = dayLengthMultiplier;
    }

    public void setSeasonTemp(float seasonTemp) {
        this.seasonTemp = seasonTemp;
    }

    public void setWorldTemp(float worldTemp) {
        this.worldTemp = worldTemp;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public void setTicksFromStart(long ticksFromStart) {
        this.ticksFromStart = ticksFromStart;
    }

    public float getSeasonTemp() {
        return this.seasonTemp;
    }

    public void setWind(float wind) {
        this.wind = wind;
    }

    public int getDayLengthMultiplier() {
        return this.dayLengthMultiplier;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getWorldTemp() {
        return this.worldTemp;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public long getTicksFromStart() {
        return this.ticksFromStart;
    }

    public float getWind() {
        return this.wind;
    }
}

