/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.ConfigKeys;
import aiven.zomboidhealthsystem.ModDamageTypes;
import aiven.zomboidhealthsystem.ModItems;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.player.conditions.Condition;
import aiven.zomboidhealthsystem.foundation.player.conditions.Thirst;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import aiven.zomboidhealthsystem.foundation.world.Weather;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;

public class Temperature
extends Condition {
    public static final int UPDATE_MULTIPLIER = Math.max(20 / Health.UPDATE_FREQUENCY, 1);
    public static final int UPDATE_FREQUENCY = Health.UPDATE_FREQUENCY * UPDATE_MULTIPLIER;
    public static final float MIN_COMFORTABLE_TEMPERATURE = 15.0f;
    public static final float MAX_COMFORTABLE_TEMPERATURE = 30.0f;
    public static final float MIN_TEMPERATURE_BODY = 27.0f;
    public static final float MAX_TEMPERATURE_BODY = 43.0f;
    public static final float AVERAGE_TEMPERATURE_BODY = 36.6f;
    private final class_1282 hypothermia;
    private final class_1282 hyperthermia;
    private float heat = 0.0f;
    private float heatFromCampfire = 0.0f;
    private float heatFromFurnace = 0.0f;
    private float perceivedTemperature = 0.0f;
    private int i = 0;

    public Temperature(Health health) {
        super(health);
        this.setAmount(36.6f);
        this.hypothermia = Util.getDamageSource(ModDamageTypes.HYPOTHERMIA, this.getPlayer().method_37908());
        this.hyperthermia = Util.getDamageSource(ModDamageTypes.HYPERTHERMIA, this.getPlayer().method_37908());
    }

    @Override
    public void update() {
        float deltaTemp = this.getAmount() - 36.6f;
        if (ModServer.getInstance().getProperties().hasTemperature() && this.getPlayer().method_37908().equals(ModServer.getInstance().getOverworld()) && this.i++ >= UPDATE_MULTIPLIER - 1) {
            Weather weather = ModServer.getInstance().getWeather();
            Thirst thirst = this.getHealth().getThirst();
            float temperature = weather.getTemperatureOnPos(this.getHealth().getPlayer().method_24515());
            float minComfortableTemp = this.getMinComfortableTemperature();
            float maxComfortableTemp = this.getMaxComfortableTemperature();
            float d = this.getHeat() + this.getHeatFromArmor() + this.getHeatFromFurnace() + this.getHeatFromCampfire();
            float lava = this.getHeatFromLava();
            temperature += d + lava;
            if (this.getPlayer().method_6059(ModStatusEffects.WIND)) {
                int amplifier = this.getPlayer().method_6112(ModStatusEffects.WIND).method_5578();
                temperature -= (float)amplifier;
            }
            this.perceivedTemperature = temperature -= this.getHealth().getWet().getAmount() * 2.5f;
            if (temperature < minComfortableTemp) {
                this.amount -= (minComfortableTemp - temperature) / 2.0f / 10000.0f * ConfigKeys.TEMPERATURE_MULTIPLIER.getValue().floatValue() * (float)UPDATE_FREQUENCY;
            } else if (temperature - d / 2.0f > maxComfortableTemp) {
                this.amount += (temperature - d / 2.0f - maxComfortableTemp) / 2.0f / 10000.0f / 5.0f * ConfigKeys.TEMPERATURE_MULTIPLIER.getValue().floatValue() * (float)UPDATE_FREQUENCY;
            } else if (this.amount < 36.5f) {
                this.amount += 0.003f * ConfigKeys.TEMPERATURE_MULTIPLIER.getValue().floatValue() * (float)UPDATE_FREQUENCY;
                this.getHealth().getHunger().reduceHunger(1.0E-4f * (float)UPDATE_FREQUENCY);
            } else if (this.amount > 36.699997f) {
                this.amount -= 0.003f / ((thirst.getAmount() + 1.0f) * 1.5f) * ConfigKeys.TEMPERATURE_MULTIPLIER.getValue().floatValue() * (float)UPDATE_FREQUENCY;
                thirst.setAmount(thirst.getAmount() + thirst.getSpeed() / 3.0f);
            }
            this.heat = 0.0f;
            this.heatFromCampfire = 0.0f;
            this.heatFromFurnace = 0.0f;
            this.i = 0;
        }
        if (this.amount < 34.0f) {
            this.getHealth().getExhaustion().addMultiplier(Float.valueOf(1.35f));
            this.getHealth().addStatusEffect(ModStatusEffects.HYPOTHERMIA, (int)Math.max(-deltaTemp / 3.0f, 1.0f), 300);
            this.getHealth().addStatusEffect(class_1294.field_5909, (int)(-deltaTemp / 3.0f), 300);
            if (this.amount < 27.0f) {
                this.getHealth().onDeath(this.hypothermia);
            }
        } else if (this.amount > 39.0f) {
            this.getHealth().getExhaustion().addMultiplier(Float.valueOf(1.35f));
            this.getHealth().addStatusEffect(ModStatusEffects.HYPERTHERMIA, (int)Math.max(deltaTemp / 2.4f, 1.0f), 300);
            this.getHealth().addStatusEffect(class_1294.field_5909, (int)(deltaTemp / 2.4f), 300);
            if (this.amount > 43.0f) {
                this.getHealth().onDeath(this.hyperthermia);
            }
        }
    }

    @Override
    public void onSleep() {
        if (Math.pow(36.6f - this.getAmount(), 1.0) > 1.0) {
            this.heal(5);
        }
    }

    @Override
    class_1291 getEffect() {
        return null;
    }

    @Override
    public String getId() {
        return "temperature";
    }

    @Override
    public String getNbt() {
        if (this.getAmount() == 36.6f) {
            return null;
        }
        return super.getNbt();
    }

    private float getMinComfortableTemperature() {
        Health health = this.getHealth();
        Thirst thirst = health.getThirst();
        float hpPercent = (float)Math.sqrt(health.getBodyHpPercent());
        float foodLvlPercent = (float)this.getPlayer().method_7344().method_7586() / 20.0f;
        foodLvlPercent = (float)Math.cbrt(Math.cbrt(foodLvlPercent));
        return 15.0f / hpPercent / foodLvlPercent + Math.max(thirst.getAmount() - 1.0f, 0.0f) * 2.0f;
    }

    private float getMaxComfortableTemperature() {
        Health health = this.getHealth();
        Thirst thirst = health.getThirst();
        return 30.0f - Math.max(thirst.getAmount() - 1.0f, 0.0f) * 2.0f;
    }

    public void heal(int divisor) {
        this.setTemperature((36.6f * (float)divisor + this.getAmount()) / (float)(2 + (divisor - 1)));
    }

    public void cool(float amount) {
        this.amount = this.getAmount() - amount > 36.6f ? (this.amount -= amount) : (this.amount -= amount / 2.0f);
    }

    public void setHeat(float heat) {
        this.heat = heat;
    }

    public void setHeatFromCampfire(float heatFromCampfire) {
        this.heatFromCampfire = heatFromCampfire;
    }

    public void setHeatFromFurnace(float heatFromFurnace) {
        this.heatFromFurnace = heatFromFurnace;
    }

    public float getHeatFromCampfire() {
        return this.heatFromCampfire;
    }

    public float getHeatFromFurnace() {
        return this.heatFromFurnace;
    }

    public void setTemperature(float temperature) {
        this.amount = temperature;
    }

    public void addHeat(float heat) {
        this.heat += heat;
    }

    public float getHeat() {
        return this.heat;
    }

    public float getPerceivedTemperature() {
        return this.perceivedTemperature;
    }

    public float getHeatFromLava() {
        float distance = Util.getDistance(this.getPlayer().method_37908(), class_2246.field_10164, this.getPlayer().method_24515(), 5);
        if (distance == -1.0f || distance >= 5.0f) {
            return 0.0f;
        }
        return 25.0f - distance * 5.0f;
    }

    private float getHeatFromArmor() {
        class_1657 player = this.getHealth().getPlayer();
        float heat = 0.0f;
        for (class_1799 stack : player.method_5661()) {
            class_1792 item = stack.method_7909();
            if (item.equals(class_1802.field_8162)) continue;
            if (item.equals(class_1802.field_8267)) {
                heat += 4.5f;
                continue;
            }
            if (item.equals(class_1802.field_8577)) {
                heat += 6.5f;
                continue;
            }
            if (item.equals(class_1802.field_8570)) {
                heat += 5.0f;
                continue;
            }
            if (item.equals(class_1802.field_8370)) {
                heat += 4.5f;
                continue;
            }
            if (item.equals(ModItems.WOOL_HELMET)) {
                heat += 6.5f;
                continue;
            }
            if (item.equals(ModItems.WOOL_CHESTPLATE)) {
                heat += 8.5f;
                continue;
            }
            if (item.equals(ModItems.WOOL_LEGGINGS)) {
                heat += 7.5f;
                continue;
            }
            if (item.equals(ModItems.WOOL_BOOTS)) {
                heat += 6.5f;
                continue;
            }
            heat += 1.0f;
        }
        return heat;
    }
}

