/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.world;

import aiven.zomboidhealthsystem.ConfigKeys;
import aiven.zomboidhealthsystem.ZomboidHealthSystem;
import aiven.zomboidhealthsystem.foundation.network.PacketIds;
import aiven.zomboidhealthsystem.foundation.network.ServerNetwork;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.world.Weather;
import aiven.zomboidhealthsystem.foundation.world.WorldProperties;
import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.JsonConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ModServer {
    public static WorldProperties WORLD_PROPERTIES_ON_START = WorldProperties.DEFAULT.copy();
    static ModServer SERVER;
    public static final int UPDATE_FREQUENCY;
    protected File playersFile;
    protected File worldFile;
    private JsonConfig playersConfig;
    private JsonConfig worldConfig;
    private final HashMap<class_1657, Health> playerMap = new HashMap();
    private Codec<Weather> weatherCodec;
    protected Codec<WorldProperties> propertiesCodec;
    protected final MinecraftServer minecraftServer;
    protected final String path;
    private class_3218 overworld;
    protected boolean isReady = false;
    private int i = 0;
    private int ticks = 0;

    public ModServer(MinecraftServer server, String path) {
        this.minecraftServer = server;
        this.path = path;
    }

    public void run() throws IOException {
        this.playersFile = new File(this.path, "players.json");
        if (!this.playersFile.exists()) {
            this.playersFile.createNewFile();
        }
        this.playersConfig = new JsonConfig(this.playersFile);
        SERVER = this;
    }

    public void tick() {
        if (this.isReady) {
            if (this.ticks++ >= UPDATE_FREQUENCY) {
                this.update();
                this.ticks = 0;
            }
            this.getWeather().tick();
            int multiplier = this.getProperties().getDayLengthMultiplier();
            if (multiplier > 0 && this.i++ >= multiplier - 1) {
                this.getProperties().addTicks(1);
                this.i = 0;
            }
        }
    }

    public void update() {
        for (class_1657 player : this.overworld.method_18456()) {
            this.sendPacketWorld(player);
        }
    }

    public void loadOverworld(class_3218 world) throws IOException {
        this.overworld = world;
        this.worldFile = new File(this.path, "world.json");
        boolean exists = this.worldFile.exists();
        if (!exists) {
            this.worldFile.createNewFile();
        }
        this.worldConfig = new JsonConfig(this.worldFile);
        this.propertiesCodec = new Codec<Object>("properties", null);
        this.weatherCodec = new Codec<Object>("weather", null);
        if (!exists) {
            this.propertiesCodec.setValue(WORLD_PROPERTIES_ON_START.copy());
            this.weatherCodec.setValue(new Weather(world, this.propertiesCodec.getValue()));
        } else {
            this.propertiesCodec.setValue(WorldProperties.parseWorldProperties(this.worldConfig.getValue(this.propertiesCodec)));
            this.weatherCodec.setValue(Weather.parseWeather(world, this.propertiesCodec.getValue(), this.worldConfig.getValue(this.weatherCodec)));
            WORLD_PROPERTIES_ON_START = this.getPropertiesCodec().getValue();
        }
        this.worldConfig.add(this.propertiesCodec);
        this.worldConfig.add(this.weatherCodec);
        this.isReady = true;
    }

    public void sendPacketWorld(class_1657 player) {
        Weather weather = this.getWeather();
        if (weather.getWorld().equals(player.method_37908())) {
            int[] array = new int[]{(int)(weather.getTemperatureOnPos(player.method_24515()) * 10.0f), (int)(weather.getWorldTemperature() * 10.0f), (int)(weather.getSeasonTemperature() * 10.0f), (int)(weather.getWind() * 10.0f), this.getProperties().getDayLengthMultiplier()};
            class_2540 packet = PacketByteBufs.create();
            packet.method_10806(array);
            packet.writeBoolean(this.getProperties().hasTemperature());
            ServerNetwork.send(PacketIds.Client.WORLD, (class_3222)player, packet);
        }
    }

    public void sendPacketHealth(class_1657 player) {
        Health health = this.getHealth(player);
        ServerNetwork.send(PacketIds.Client.HEALTH, (class_3222)player, PacketByteBufs.create().method_10814(health.toString()));
    }

    public void sendPacketDamage(class_1657 player) {
        ServerNetwork.send(PacketIds.Client.DAMAGE, (class_3222)player, PacketByteBufs.create());
    }

    protected Health getHealthFromConfig(class_1657 player) {
        String value = this.playersConfig.getValue(this.getCodecName(player));
        if (value == null) {
            return null;
        }
        return Health.parseHealth(player, value);
    }

    public Health getHealth(class_1657 player) {
        return this.playerMap.get(player);
    }

    protected void addPlayer(class_1657 player, Health health) {
        this.playerMap.put(player, health);
    }

    public void onConnectedPlayer(class_1657 player) {
        Health health = this.getHealthFromConfig(player);
        if (health == null) {
            this.addPlayer(player, new Health(player));
        } else {
            this.addPlayer(player, health);
        }
    }

    public void onRespawnedPlayer(class_1657 player) {
        this.addPlayer(player, new Health(player));
        this.sendPacketHealth(player);
    }

    public void onDisconnectedPlayer(class_1657 player) throws IOException {
        this.playersConfig.add(this.getCodecName(player), this.getHealth(player).toString());
    }

    public void damagePlayer(class_1657 player, class_1282 source, float amount) {
        try {
            this.getHealth(player).damageBodyParts(source, amount * ConfigKeys.DAMAGE_MULTIPLIER.getValue().floatValue());
            this.sendPacketHealth(player);
            this.sendPacketDamage(player);
        }
        catch (Exception e) {
            this.print(player.method_5477().getString() + ":\n\t" + e);
        }
    }

    public void stop() throws IOException {
        this.playersConfig.save();
        this.worldConfig.save();
        WORLD_PROPERTIES_ON_START = WorldProperties.DEFAULT.copy();
        SERVER = null;
    }

    public Weather getWeather() {
        return this.weatherCodec.getValue();
    }

    public static ModServer getInstance() {
        return SERVER;
    }

    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    public Codec<WorldProperties> getPropertiesCodec() {
        return this.propertiesCodec;
    }

    public WorldProperties getProperties() {
        return this.getPropertiesCodec().getValue();
    }

    public class_3218 getOverworld() {
        return this.overworld;
    }

    private void print(String string) {
        ZomboidHealthSystem.LOGGER.info(string);
    }

    public String getCodecName(class_1657 player) {
        return player.method_5477().getString();
    }

    static {
        UPDATE_FREQUENCY = Math.max(ZomboidHealthSystem.UPDATE_FREQUENCY, 20);
    }
}

