/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem;

import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.Config;

public class ConfigArgs {
    public static final Config CONFIG = ConfigArgs.initialize();
    public static Config.Argument<Boolean> PAIN_KEEPS_AWAKE;
    public static Config.Argument<Boolean> CRAWL_DELAY;
    public static Config.Argument<Float> TEMPERATURE_MULTIPLIER;
    public static Config.Argument<Float> COLD_MULTIPLIER;
    public static Config.Argument<Float> DROWSINESS_MULTIPLIER;
    public static Config.Argument<Float> THIRST_MULTIPLIER;
    public static Config.Argument<Float> EXHAUSTION_MULTIPLIER;
    public static Config.Argument<Float> WET_MULTIPLIER;
    public static Config.Argument<Float> DAMAGE_MULTIPLIER;
    public static Config.Argument<Float> MAX_TEMPERATURE_SEASON;
    public static Config.Argument<Float> WIND_CHANCE;
    public static Config.Argument<Integer> MIN_HUNGER_FOR_SLEEP;
    public static Config.Argument<Integer> HEAL_TIME;
    public static Config.Argument<Integer> FOOD_HEAL_AMOUNT;
    public static Config.Argument<Integer> HUD_X;
    public static Config.Argument<Integer> HUD_Y;

    public static Config initialize() {
        try {
            Config config = Config.getInstance();
            PAIN_KEEPS_AWAKE = config.addArgument(new Codec<Boolean>("pain_keeps_awake", true));
            CRAWL_DELAY = config.addArgument(new Codec<Boolean>("crawl_delay", true));
            TEMPERATURE_MULTIPLIER = config.addArgument(new Codec<Float>("temperature_multiplier", Float.valueOf(1.0f)));
            COLD_MULTIPLIER = config.addArgument(new Codec<Float>("cold_multiplier", Float.valueOf(1.0f)));
            DROWSINESS_MULTIPLIER = config.addArgument(new Codec<Float>("drowsiness_multiplier", Float.valueOf(1.0f)));
            THIRST_MULTIPLIER = config.addArgument(new Codec<Float>("thirst_multiplier", Float.valueOf(1.0f)));
            EXHAUSTION_MULTIPLIER = config.addArgument(new Codec<Float>("exhaustion_multiplier", Float.valueOf(1.0f)));
            WET_MULTIPLIER = config.addArgument(new Codec<Float>("wet_multiplier", Float.valueOf(1.0f)));
            DAMAGE_MULTIPLIER = config.addArgument(new Codec<Float>("damage_multiplier", Float.valueOf(1.1f)));
            MAX_TEMPERATURE_SEASON = config.addArgument(new Codec<Float>("max_temperature_season", Float.valueOf(20.0f)));
            WIND_CHANCE = config.addArgument(new Codec<Float>("wind_chance", Float.valueOf(0.33f)));
            MIN_HUNGER_FOR_SLEEP = config.addArgument(new Codec<Integer>("min_hunger_for_sleep", 11));
            HEAL_TIME = config.addArgument(new Codec<Integer>("heal_time", 48000));
            FOOD_HEAL_AMOUNT = config.addArgument(new Codec<Integer>("food_heal_amount", 5));
            HUD_X = config.addArgument(new Codec<Integer>("hud_x", 10));
            HUD_Y = config.addArgument(new Codec<Integer>("hud_y", 30));
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException("error in config: " + e);
        }
    }
}

