/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem;

import aiven.zomboidhealthsystem.ZomboidHealthSystem;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import aiven.zomboidhealthsystem.foundation.world.WorldProperties;
import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.JsonFile;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import java.io.IOException;
import net.fabricmc.api.DedicatedServerModInitializer;

public class ZomboidHealthSystemServer
implements DedicatedServerModInitializer {
    public static final String PATH = System.getProperty("user.dir");
    public static final Codec<WorldProperties> DEFAULT_PROPERTIES = new Codec<Object>("default world properties", null);

    public void onInitializeServer() {
        ZomboidHealthSystem.isServer = true;
    }

    public static void initialize() throws IOException {
        JsonFile file = new JsonFile(PATH, "zomboidhealthsystem.json");
        JsonHelper config = new JsonHelper(file);
        if (!file.wasFile()) {
            DEFAULT_PROPERTIES.setValue(ModServer.WORLD_PROPERTIES_ON_START);
            config.setDefault(DEFAULT_PROPERTIES);
        } else {
            DEFAULT_PROPERTIES.setValue(WorldProperties.parseWorldProperties(config.getValue(DEFAULT_PROPERTIES)));
            ModServer.WORLD_PROPERTIES_ON_START = DEFAULT_PROPERTIES.getValue();
        }
    }
}

