/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ModDamageTypes;
import aiven.zomboidhealthsystem.ModItems;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import aiven.zomboidhealthsystem.foundation.world.Weather;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;

public final class Temperature {
    private static final int TICKS_AMPLIFIER = Math.max(4, 1);
    private static final int UPDATE_EVERY_TICKS = 5 * TICKS_AMPLIFIER;
    public static final float MIN_COMFORTABLE_TEMPERATURE = 15.0f;
    public static final float MAX_COMFORTABLE_TEMPERATURE = 30.0f;
    public static final float MIN_TEMPERATURE_BODY = 27.0f;
    public static final float MAX_TEMPERATURE_BODY = 43.0f;
    public static final float AVERAGE_TEMPERATURE_BODY = 36.6f;
    private final class_1282 hypothermia;
    private final class_1282 hyperthermia;
    private final Health health;
    private float temperature = 36.6f;
    private float warm = 0.0f;
    private int i = 0;

    public Temperature(Health health) {
        this.health = health;
        this.hypothermia = Util.getDamageSource(ModDamageTypes.HYPOTHERMIA, health.getPlayer());
        this.hyperthermia = Util.getDamageSource(ModDamageTypes.HYPERTHERMIA, health.getPlayer());
    }

    public void update() {
        if (ModServer.getInstance().getProperties().hasTemperature() && this.getPlayer().method_37908().equals(ModServer.getInstance().getOverworld())) {
            float deltaTemp = this.getAmount() - 36.6f;
            if (this.i++ >= TICKS_AMPLIFIER - 1) {
                Weather weather = ModServer.getInstance().getWeather();
                float temperature = weather.getTemperatureOnPos(this.getHealth().getPlayer().method_24515());
                float d = this.getWarm() * 6.0f + this.getWarmFromArmor();
                temperature += d;
                if (this.getPlayer().method_6059(ModStatusEffects.WIND)) {
                    int amplifier = this.getPlayer().method_6112(ModStatusEffects.WIND).method_5578();
                    temperature -= (float)amplifier;
                }
                temperature -= this.getHealth().getWet().getAmount() * 3.0f;
                class_1702 hunger = this.getHealth().getPlayer().method_7344();
                float foodLevelPercent = (float)hunger.method_7586() / 20.0f;
                float thirstLevel = this.getHealth().getThirst().getAmount();
                float hpPercent = this.getHealth().getMaxSumHp() / this.getHealth().getSumHp();
                if (temperature < 15.0f) {
                    this.temperature -= (15.0f - temperature) / 2.0f / 10000.0f / (1.0f + this.getHealth().getExhaustion().getAmount() / 3.0f) / (hpPercent * hpPercent) / ((foodLevelPercent + 2.0f) / 3.0f) * ConfigArgs.TEMPERATURE_MULTIPLIER.getFloatValue().floatValue() * (float)UPDATE_EVERY_TICKS;
                } else {
                    float f;
                    temperature -= d / 2.0f;
                    if (f > 30.0f) {
                        this.temperature += (temperature - 30.0f) / 2.0f / 10000.0f * (1.0f + this.getHealth().getExhaustion().getAmount() / 2.0f) / 5.0f * (thirstLevel + 1.0f) * ConfigArgs.TEMPERATURE_MULTIPLIER.getFloatValue().floatValue() * (float)UPDATE_EVERY_TICKS;
                    } else if (this.temperature < 36.5f) {
                        this.temperature += 0.003f * (foodLevelPercent / 2.0f + 0.5f) * (hpPercent * hpPercent) * Math.max(this.warm / 3.0f, 1.0f) * ConfigArgs.TEMPERATURE_MULTIPLIER.getFloatValue().floatValue() * (float)UPDATE_EVERY_TICKS;
                        this.getHealth().getHunger().reduceHunger(0.01f);
                    } else if (this.temperature > 36.699997f) {
                        this.temperature -= 0.003f / ((thirstLevel + 1.0f) * 1.5f) * ConfigArgs.TEMPERATURE_MULTIPLIER.getFloatValue().floatValue() * (float)UPDATE_EVERY_TICKS;
                        this.getHealth().getThirst().setAmount(this.getHealth().getThirst().getAmount() + 0.001f * (float)UPDATE_EVERY_TICKS);
                    }
                }
                this.setWarm(0.0f);
                this.i = 0;
            }
            if (this.temperature < 34.0f) {
                this.getHealth().getExhaustion().addAmplifier(Float.valueOf(1.35f));
                this.getHealth().updateStatusEffect(ModStatusEffects.HYPOTHERMIA, (int)Math.max(-deltaTemp / 3.0f, 1.0f));
                this.getHealth().updateStatusEffect(class_1294.field_5909, (int)(-deltaTemp / 3.0f));
                if (this.temperature < 27.0f) {
                    this.getHealth().onDeath(this.hypothermia);
                }
            } else if (this.temperature > 39.0f) {
                this.getHealth().getExhaustion().addAmplifier(Float.valueOf(1.35f));
                this.getHealth().updateStatusEffect(ModStatusEffects.HYPERTHERMIA, (int)Math.max(deltaTemp / 3.0f, 1.0f));
                this.getHealth().updateStatusEffect(class_1294.field_5909, (int)(deltaTemp / 3.0f));
                if (this.temperature > 43.0f) {
                    this.getHealth().onDeath(this.hyperthermia);
                }
            }
        } else {
            this.setTemperature(36.6f);
        }
    }

    public void onSleep() {
        if (Math.pow(36.6f - this.getAmount(), 1.0) > 1.0) {
            this.heal(5);
        }
    }

    public void heal(int divisor) {
        this.setTemperature((36.6f * (float)divisor + this.getAmount()) / (float)(2 + (divisor - 1)));
    }

    public void cool(float amount) {
        this.temperature = this.getAmount() - amount > 36.6f ? (this.temperature -= amount) : (this.temperature -= Math.max(amount / 5.0f, this.getAmount() - 36.6f));
    }

    public Health getHealth() {
        return this.health;
    }

    public void setWarm(float warm) {
        this.warm = warm;
    }

    public float getAmount() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature > 0.0f ? temperature : 0.0f;
    }

    public float getWarm() {
        float distance = Util.getDistance(this.getPlayer().method_37908(), class_2246.field_10164, this.getPlayer().method_24515(), 5);
        return Math.max(5.0f - distance, this.warm);
    }

    public class_1657 getPlayer() {
        return this.getHealth().getPlayer();
    }

    private float getWarmFromArmor() {
        class_1657 player = this.getHealth().getPlayer();
        float d = 0.0f;
        for (class_1799 stack : player.method_5661()) {
            class_1792 item = stack.method_7909();
            if (item.equals(class_1802.field_8162)) continue;
            if (item.equals(class_1802.field_8267)) {
                d += 1.2f;
                continue;
            }
            if (item.equals(class_1802.field_8577)) {
                d += 2.0f;
                continue;
            }
            if (item.equals(class_1802.field_8570)) {
                d += 1.5f;
                continue;
            }
            if (item.equals(class_1802.field_8370)) {
                d += 1.0f;
                continue;
            }
            if (item.equals(ModItems.WOOL_HELMET)) {
                d += 1.7f;
                continue;
            }
            if (item.equals(ModItems.WOOL_CHESTPLATE)) {
                d += 3.0f;
                continue;
            }
            if (item.equals(ModItems.WOOL_LEGGINGS)) {
                d += 2.2f;
                continue;
            }
            if (item.equals(ModItems.WOOL_BOOTS)) {
                d += 1.5f;
                continue;
            }
            d += 0.75f;
        }
        return d;
    }
}

