/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.world;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ZomboidHealthSystem;
import aiven.zomboidhealthsystem.foundation.network.PacketId;
import aiven.zomboidhealthsystem.foundation.network.ServerNetwork;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.world.Weather;
import aiven.zomboidhealthsystem.foundation.world.WorldProperties;
import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.JsonFile;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import java.io.IOException;
import java.util.HashMap;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ModServer {
    public static WorldProperties WORLD_PROPERTIES_ON_START = WorldProperties.DEFAULT;
    static ModServer SERVER;
    private static final int UPDATE_EVERY_TICKS = 20;
    protected JsonFile playersFile;
    protected JsonFile worldFile;
    private JsonHelper playersConfig;
    private JsonHelper worldConfig;
    private final HashMap<class_1657, Codec<Health>> playerCodecs = new HashMap();
    private Codec<Weather> weather;
    protected Codec<WorldProperties> properties;
    protected final MinecraftServer minecraftServer;
    protected final String path;
    private class_3218 overworld;
    protected boolean isReady = false;
    private int i = 0;
    private int ticks = 0;

    public ModServer(MinecraftServer server, String path) {
        this.minecraftServer = server;
        this.path = path;
    }

    public void run() throws IOException {
        this.playersFile = new JsonFile(this.path, "players.data");
        this.playersConfig = new JsonHelper(this.playersFile);
        if (!this.playersFile.wasFile()) {
            this.playersConfig.setDefault(new Codec[0]);
        }
        SERVER = this;
    }

    public void tick() {
        if (this.isReady) {
            if (this.ticks++ >= 20) {
                this.update();
                this.ticks = 0;
            }
            this.getWeather().tick();
            ++this.i;
            if (this.i >= this.getProperties().getDayLengthMultiplier()) {
                this.getProperties().setTicks(this.properties.getValue().getTicks() + 1);
                this.i = 0;
            }
        }
    }

    public void update() {
        for (class_1657 player : this.overworld.method_18456()) {
            this.sendPacketWorld(player);
        }
    }

    public void loadOverworld(class_3218 world) throws IOException {
        this.overworld = world;
        this.worldFile = new JsonFile(this.path, "world.data");
        this.worldConfig = new JsonHelper(this.worldFile);
        this.properties = new Codec<Object>("properties", null);
        this.weather = new Codec<Object>("weather", null);
        if (!this.worldFile.wasFile()) {
            this.properties.setValue(WORLD_PROPERTIES_ON_START);
            this.weather.setValue(new Weather(world, this.getPropertiesCodec().getValue()));
            this.worldConfig.setDefault(this.properties, this.weather);
        } else {
            String config = this.worldConfig.toString();
            this.properties.setValue(WorldProperties.parseWorldProperties(JsonHelper.getValue(config, "properties")));
            this.weather.setValue(Weather.parseWeather(world, this.getProperties(), JsonHelper.getValue(config, "weather")));
            WORLD_PROPERTIES_ON_START = this.getPropertiesCodec().getValue();
        }
        this.isReady = true;
    }

    public void sendPacketWorld(class_1657 player) {
        Weather weather = this.getWeather();
        if (weather.getWorld().equals(player.method_37908())) {
            int d = (int)weather.getTemperature() * 10;
            int[] f = new int[]{d, weather.properties.getDayLengthMultiplier(), (int)(weather.getTemperatureOnPos(player.method_24515()) * 10.0f)};
            class_2540 packet = PacketByteBufs.create();
            packet.method_10814(this.getWeather().toString());
            packet.method_10806(f);
            packet.writeBoolean(this.getProperties().hasTemperature());
            ServerNetwork.send(PacketId.WORLD, (class_3222)player, packet);
        }
    }

    public void sendPacketHealth(class_1657 player) {
        Health health = this.getHealth(player);
        ServerNetwork.send(PacketId.HEALTH, (class_3222)player, PacketByteBufs.create().method_10814(health.toString()));
    }

    public void sendPacketDamage(class_1657 player) {
        ServerNetwork.send(PacketId.DAMAGE, (class_3222)player, PacketByteBufs.create());
    }

    protected Health getHealthFromConfig(class_1657 player) {
        String value = JsonHelper.getValue(this.playersConfig.toString(), this.getCodecName(player));
        if (value != null) {
            return Health.parseHealth(player, value);
        }
        return null;
    }

    public Health getHealth(class_1657 player) {
        Codec<Health> codec = this.playerCodecs.get(player);
        if (codec != null) {
            return codec.getValue();
        }
        return null;
    }

    protected void addPlayer(class_1657 player, Health health) {
        this.playerCodecs.put(player, new Codec<Health>(this.getCodecName(player), health));
    }

    public void onConnectedPlayer(class_1657 player) {
        Health health = this.getHealthFromConfig(player);
        if (health == null) {
            this.addPlayer(player, new Health(player));
        } else {
            this.addPlayer(player, health);
        }
    }

    public void onRespawnedPlayer(class_1657 player) {
        this.addPlayer(player, new Health(player));
    }

    public void onDisconnectedPlayer(class_1657 player) throws IOException {
        this.playersConfig.writeCodecsInConfig(this.playerCodecs.get(player));
        this.playerCodecs.remove(player);
    }

    public void damagePlayer(class_1657 player, class_1282 source, float amount) {
        try {
            this.playerCodecs.get(player).getValue().damageBodyParts(source, amount * ConfigArgs.DAMAGE_MULTIPLIER.getFloatValue().floatValue());
            this.sendPacketHealth(player);
            this.sendPacketDamage(player);
        }
        catch (Exception e) {
            this.print(player.method_5477().getString() + ":\n\te");
        }
    }

    public void stop() throws IOException {
        for (class_1657 player : this.playerCodecs.keySet()) {
            this.playersConfig.writeCodecsInConfig(this.playerCodecs.get(player));
        }
        this.worldConfig.writeCodecsInConfig(this.properties, this.weather);
        this.playersConfig.save();
        this.worldConfig.save();
        WORLD_PROPERTIES_ON_START = WorldProperties.DEFAULT;
        SERVER = null;
    }

    public Weather getWeather() {
        return this.weather.getValue();
    }

    public static ModServer getInstance() {
        return SERVER;
    }

    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    public Codec<WorldProperties> getPropertiesCodec() {
        return this.properties;
    }

    public WorldProperties getProperties() {
        return this.getPropertiesCodec().getValue();
    }

    public class_3218 getOverworld() {
        return this.overworld;
    }

    private void print(String string) {
        ZomboidHealthSystem.LOGGER.info(string);
    }

    public String getCodecName(class_1657 player) {
        return player.method_5477().getString();
    }
}

