/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.infrastructure.config;

import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.infrastructure.config.Codec;
import aiven.zomboidhealthsystem.infrastructure.config.JsonFile;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import java.io.IOException;

public class Config {
    private static Config INSTANCE = null;
    public final String minecraftDir = Util.getMinecraftDirectory();
    private final JsonHelper helper = new JsonHelper(new JsonFile(this.minecraftDir + "/config", "zomboidhealthsystem-1.2.json"));

    private Config() throws IOException {
        if (!this.helper.file().wasFile()) {
            this.helper.setDefault(new Codec[0]);
        }
    }

    public <T> Argument<T> addArgument(Codec<T> codec) throws IOException {
        Argument<T> argument = new Argument<T>(codec, this.helper);
        if (!this.helper.file().wasFile()) {
            this.helper.writeCodecsInConfig(codec);
            this.helper.save();
        }
        return argument;
    }

    public static Config getInstance() throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new Config();
        }
        return INSTANCE;
    }

    public static class Argument<T> {
        private final Codec<T> codec;
        private final T defaultValue;
        private final JsonHelper helper;
        private String value;

        private Argument(Codec<T> defaultValue, JsonHelper helper) {
            this.codec = defaultValue;
            this.defaultValue = defaultValue.getValue();
            this.helper = helper;
        }

        public void setValue(T value) {
            try {
                this.codec.setValue(value);
                this.helper.writeCodecsInConfig(this.codec);
                this.helper.save();
                this.value = value.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getStringValue() {
            if (this.value == null) {
                try {
                    this.value = this.helper.getValue(this.codec);
                    if (this.value == null) {
                        this.value = this.defaultValue.toString();
                    }
                }
                catch (Exception e) {
                    this.value = this.defaultValue.toString();
                }
            }
            return this.value;
        }

        public Float getFloatValue() {
            return Float.valueOf(Float.parseFloat(this.getStringValue()));
        }

        public Double getDoubleValue() {
            return Double.parseDouble(this.getStringValue());
        }

        public Integer getIntegerValue() {
            return Integer.parseInt(this.getStringValue());
        }

        public Boolean getBooleanValue() {
            return Boolean.parseBoolean(this.getStringValue());
        }
    }
}

