/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.network;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ModItems;
import aiven.zomboidhealthsystem.ZomboidHealthSystem;
import aiven.zomboidhealthsystem.foundation.items.BandageItem;
import aiven.zomboidhealthsystem.foundation.network.ClientPackets;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4050;

public enum ServerTasks {
    BANDAGE((minecraftServer, serverPlayerEntity, serverPlayNetworkHandler, packetByteBuf, packetSender) -> {
        try {
            String bodyPart = packetByteBuf.method_19772();
            int type = packetByteBuf.method_10816();
            class_1661 inventory = serverPlayerEntity.method_31548();
            BandageItem bandageItem = (BandageItem)class_1792.method_7875((int)type);
            inventory.method_5438(inventory.method_7395(bandageItem.method_7854())).method_7934(1);
            Util.setCooldownAllBandageItems(serverPlayerEntity.method_7357(), 120);
            ModServer.getInstance().getHealth((class_1657)serverPlayerEntity).partHashMap.get(bodyPart).bandage(bandageItem);
        }
        catch (Exception e) {
            ServerTasks.print(EXCEPTION.formatted(e, ClientPackets.BANDAGE.getIdentifier().method_12832(), serverPlayerEntity.method_5477().getString()));
        }
    }),
    UNBANDAGE((minecraftServer, serverPlayerEntity, serverPlayNetworkHandler, packetByteBuf, packetSender) -> {
        try {
            if (ModServer.getInstance().playerCodecs.containsKey(serverPlayerEntity)) {
                String bodyPart = packetByteBuf.method_19772();
                class_1792 bandageItem = ModServer.getInstance().getHealth((class_1657)serverPlayerEntity).partHashMap.get(bodyPart).unBandage();
                serverPlayerEntity.method_7270(bandageItem.method_7854());
                Util.setCooldownAllBandageItems(serverPlayerEntity.method_7357(), 60);
            }
        }
        catch (Exception e) {
            ServerTasks.print(EXCEPTION.formatted(e, ClientPackets.UNBANDAGE.getIdentifier().method_12832(), serverPlayerEntity.method_5477().getString()));
        }
    }),
    CRAWL((minecraftServer, serverPlayerEntity, serverPlayNetworkHandler, packetByteBuf, packetSender) -> {
        try {
            int time;
            class_4050 pose;
            int amplifier = 0;
            if (serverPlayerEntity.method_6059(class_1294.field_5909)) {
                amplifier = serverPlayerEntity.method_6112(class_1294.field_5909).method_5578();
            }
            if (!serverPlayerEntity.method_20448() || amplifier >= 3) {
                pose = class_4050.field_18079;
                time = 200;
            } else if (serverPlayerEntity.method_37908().method_8320(serverPlayerEntity.method_24515().method_10086(1)).method_26204().method_9520() == 0.0f) {
                pose = class_4050.field_18076;
                time = 700;
            } else {
                pose = class_4050.field_18079;
                time = 0;
            }
            if (ConfigArgs.CRAWL_DELAY.booleanValue()) {
                new Thread(() -> {
                    try {
                        Thread.sleep(time);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    serverPlayerEntity.method_18380(pose);
                }).start();
            } else {
                serverPlayerEntity.method_18380(pose);
            }
        }
        catch (Exception e) {
            ServerTasks.print(EXCEPTION.formatted(e, ClientPackets.CRAWL.getIdentifier().method_12832(), serverPlayerEntity.method_5477().getString()));
        }
    }),
    DISINFECT((minecraftServer, serverPlayerEntity, serverPlayNetworkHandler, packetByteBuf, packetSender) -> {
        try {
            String bodyPart = packetByteBuf.method_19772();
            ModServer.getInstance().getHealth((class_1657)serverPlayerEntity).partHashMap.get(bodyPart).disInfect();
            class_1661 inv = serverPlayerEntity.method_31548();
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 item = inv.method_5438(i);
                if (!item.method_7909().equals(ModItems.ALCOHOL_WIPE)) continue;
                item.method_7974(item.method_7919() + 1);
                if (item.method_7919() <= 8) continue;
                item.method_7934(1);
            }
            serverPlayerEntity.method_7357().method_7906(ModItems.ALCOHOL_WIPE, 100);
        }
        catch (Exception e) {
            ServerTasks.print(EXCEPTION.formatted(e, ClientPackets.DISINFECT.getIdentifier().method_12832(), serverPlayerEntity.method_5477().getString()));
        }
    });

    private static final String EXCEPTION = "\nZomboid Health System:\n    %s in\n        Packet: %s\n        Player: %s\n";
    private final ServerPlayNetworking.PlayChannelHandler task;

    private ServerTasks(ServerPlayNetworking.PlayChannelHandler task) {
        this.task = task;
    }

    public ServerPlayNetworking.PlayChannelHandler get() {
        return this.task;
    }

    public static void print(String string) {
        ZomboidHealthSystem.LOGGER.info(string);
    }

    public static void initialize() {
    }
}

