/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.world;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ModItems;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.foundation.world.WorldProperties;
import aiven.zomboidhealthsystem.infrastructure.config.JsonBuilder;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class Weather {
    public static final int UPDATE_EVERY_TICKS = 20;
    final WorldProperties properties;
    long timeOfDay;
    float average_temperature;
    final class_3218 world;
    float wind;
    boolean newDay = false;
    Integer sleep = null;
    int i = 0;

    public Weather(class_3218 world, WorldProperties properties) {
        this.world = world;
        this.properties = properties;
        this.timeOfDay = world.method_8532();
        this.average_temperature = this.getTemperature();
    }

    public void tick() {
        if (this.i++ > 20 && this.properties.hasTemperature()) {
            this.update();
            this.i = 0;
        }
    }

    public void update() {
        this.timeOfDay = this.getWorld().method_8532();
        this.average_temperature = this.calculateAverageTemperature(20, (int)(this.timeOfDay % 24000L));
        if (this.timeOfDay < 20L) {
            if (!this.newDay) {
                this.onNewDay();
                this.newDay = true;
            }
        } else {
            this.newDay = false;
        }
    }

    public float getInfluenceOnEntity(class_1657 player) {
        float resist = this.getWeatherProtection(player);
        float influence = 0.0f;
        if (resist < 4.0f && this.wind > 0.0f && this.properties.hasWind() && Util.isInOpenSpace(this.getWorld(), player.method_24515())) {
            influence += this.wind + 1.0f;
            player.method_6092(new class_1293(ModStatusEffects.WIND, 80, (int)this.wind, false, false, true));
        }
        boolean bl = false;
        if (this.world.method_8320(player.method_24515()).method_26204().equals(class_2246.field_10382) && player.method_49694() == null) {
            bl = true;
            influence += 5.0f * resist + 1.0f;
            player.method_6092(new class_1293(ModStatusEffects.WET, 80, 0, false, false, true));
        }
        if (!bl && this.world.method_8520(player.method_24515()) && resist < 3.0f) {
            influence += 5.0f;
            player.method_6092(new class_1293(ModStatusEffects.WET, 80, 0, false, false, true));
        }
        return influence / (resist + 1.0f);
    }

    public float getWeatherProtection(class_1657 player) {
        float d = 0.0f;
        for (class_1799 stack : player.method_5661()) {
            class_1792 item = stack.method_7909();
            if (item.equals(class_1802.field_8162)) continue;
            if (item.equals(class_1802.field_8267)) {
                d += 1.2f;
                continue;
            }
            if (item.equals(class_1802.field_8577)) {
                d += 2.0f;
                continue;
            }
            if (item.equals(class_1802.field_8570)) {
                d += 1.5f;
                continue;
            }
            if (item.equals(class_1802.field_8370)) {
                d += 1.0f;
                continue;
            }
            if (item.equals(ModItems.WOOL_HELMET)) {
                d += 1.7f;
                continue;
            }
            if (item.equals(ModItems.WOOL_CHESTPLATE)) {
                d += 3.0f;
                continue;
            }
            if (item.equals(ModItems.WOOL_LEGGINGS)) {
                d += 2.2f;
                continue;
            }
            if (item.equals(ModItems.WOOL_BOOTS)) {
                d += 1.5f;
                continue;
            }
            d += 0.75f;
        }
        return d;
    }

    public float getTemperatureOnPos(class_2338 pos) {
        float temperatureBiome = ((class_1959)this.getWorld().method_23753(pos).comp_349()).method_8712();
        float height = pos.method_10264() - 63;
        float d = (float)pos.method_10260() / 1000.0f;
        float t = this.getAverage_temperature() - height / 25.0f + d;
        if (temperatureBiome > 0.5f) {
            t += 10.0f * temperatureBiome;
        } else if (temperatureBiome < 0.15f) {
            temperatureBiome -= 0.15f;
            t += 15.0f * (temperatureBiome *= 3.0f);
        }
        return t;
    }

    public boolean doesNotSnow(class_2338 pos) {
        class_5321 key = (class_5321)this.getWorld().method_23753(pos).method_40230().get();
        if (this.getTemperatureOnPos(pos) > 0.0f) {
            return true;
        }
        return Util.isOcean((class_5321<class_1959>)key);
    }

    public float calculateAverageTemperature(int ticks, int timeOfDay) {
        float d;
        float temp = this.average_temperature;
        float average_temp = this.getTemperature();
        float amount = 5.0E-4f * (float)ticks;
        if (timeOfDay > 10000) {
            d = temp < average_temp ? (float)Math.max(Math.pow(average_temp - (this.average_temperature - amount / 2.0f) / 2.0f, 2.0), 1.0) : 0.9f;
            temp -= amount / d * 3.0f / (float)this.properties.getDayLengthMultiplier();
        } else {
            d = temp > average_temp ? (float)Math.max(Math.pow((temp + amount / 2.0f - average_temp) / 2.0f, 2.0), 1.0) : 0.75f;
            temp += amount / d * 3.0f / (float)this.properties.getDayLengthMultiplier();
        }
        if (this.world != null) {
            float t = 0.001f / d * (float)ticks;
            if (this.world.method_8419()) {
                temp -= t * 3.0f / (float)this.properties.getDayLengthMultiplier();
            }
        }
        return temp;
    }

    public void onNewDay() {
        if (this.properties.hasWind()) {
            this.wind = new Random().nextFloat(0.0f, 1.0f) > ConfigArgs.WIND_CHANCE.floatValue() ? new Random().nextFloat(0.0f, 10.0f) : 0.0f;
        }
    }

    public void onSleep() {
        if (this.sleep != null) {
            this.average_temperature = this.calculateAverageTemperature(24000 - this.sleep, this.sleep);
            this.sleep = null;
        }
    }

    public float getTemperature() {
        return Weather.getTemperature(this.properties);
    }

    public float getAverage_temperature() {
        return this.average_temperature;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public float getWind() {
        return this.wind;
    }

    public void setWind(float wing) {
        this.wind = wing;
    }

    public void setSleep(long sleep) {
        this.sleep = (int)(sleep % 24000L);
    }

    public void setAverage_temperature(float average_temperature) {
        this.average_temperature = average_temperature;
    }

    public String toString() {
        JsonBuilder builder = new JsonBuilder("[", "]", 2);
        builder.append("\"temperature\": " + this.getAverage_temperature());
        builder.append("\"wind\": " + this.getWind());
        return builder.get();
    }

    public static float getTemperature(WorldProperties properties) {
        float temp;
        int durationYear = properties.getDaysInSeason() * 24000 * 4;
        int duration = properties.getDaysInSeason() * 24000;
        int time = properties.getTicks();
        float MAX_TEMP = ConfigArgs.MAX_TEMPERATURE_SEASON.floatValue();
        time = (time %= durationYear) >= duration / 2 ? (time -= duration / 2 + 1) : durationYear - duration / 2 + time + 1;
        float divisor = 27.0f / MAX_TEMP;
        if (time > durationYear / 2) {
            int d = (time %= durationYear / 2) / (duration / 28);
            temp = MAX_TEMP * -1.0f;
            temp += (float)d / divisor;
        } else {
            int d = (time %= durationYear / 2) / (duration / 28);
            temp = MAX_TEMP;
            temp -= (float)d / divisor;
        }
        return temp;
    }

    public static Weather parseWeather(class_3218 world, WorldProperties properties, String value) {
        Weather weather = new Weather(world, properties);
        try {
            weather.setAverage_temperature(Float.parseFloat(JsonHelper.getValue(value, "temperature")));
        }
        catch (Exception e) {
            throw new RuntimeException("error in world.data");
        }
        try {
            weather.setWind(Float.parseFloat(JsonHelper.getValue(value, "wind")));
        }
        catch (NullPointerException e) {
            weather.setWind(0.0f);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("error in world.data");
        }
        return weather;
    }
}

