/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.world;

import aiven.zomboidhealthsystem.infrastructure.config.JsonBuilder;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;

public class WorldProperties {
    public static WorldProperties DEFAULT = new WorldProperties(3, 28, 240000, true, true);
    int dayLengthMultiplier;
    int daysInSeason;
    int ticks;
    boolean temperature;
    boolean wind;

    public WorldProperties(int dayLengthMultiplier, int daysInSeason, int ticks, boolean temperature, boolean wind) {
        this.dayLengthMultiplier = dayLengthMultiplier;
        this.daysInSeason = daysInSeason;
        this.ticks = ticks;
        this.temperature = temperature;
        this.wind = wind;
    }

    public void setDaysInSeason(int daysInSeason) {
        this.daysInSeason = daysInSeason;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public void setDayLengthMultiplier(int dayLengthMultiplier) {
        this.dayLengthMultiplier = dayLengthMultiplier;
    }

    public void setTemperature(boolean temperature) {
        this.temperature = temperature;
    }

    public void setWind(boolean wind) {
        this.wind = wind;
    }

    public int getDaysInSeason() {
        return this.daysInSeason;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getDayLengthMultiplier() {
        return this.dayLengthMultiplier;
    }

    public boolean hasTemperature() {
        return this.temperature;
    }

    public boolean hasWind() {
        return this.wind;
    }

    public String toString() {
        JsonBuilder builder = new JsonBuilder("[", "]", 2);
        builder.append("day length multiplier", String.valueOf(this.dayLengthMultiplier));
        builder.append("days in season", String.valueOf(this.daysInSeason));
        builder.append("ticks", String.valueOf(this.ticks));
        builder.append("temperature", String.valueOf(this.temperature));
        builder.append("wind", String.valueOf(this.wind));
        return builder.get();
    }

    private static int getInt(String value, int defaultValue) {
        try {
            int val = Integer.parseInt(value);
            return val;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static WorldProperties parseWorldProperties(String value) {
        String dayLengthString = JsonHelper.getValue(value, "day length multiplier");
        String daysInSeasonString = JsonHelper.getValue(value, "days in season");
        String ticksString = JsonHelper.getValue(value, "ticks");
        String temperatureString = JsonHelper.getValue(value, "temperature");
        String windString = JsonHelper.getValue(value, "wind");
        int dayLength = WorldProperties.getInt(dayLengthString, 3);
        int daysInSeason = WorldProperties.getInt(daysInSeasonString, 28);
        int ticks = WorldProperties.getInt(ticksString, 240000);
        boolean temperature = temperatureString == null ? true : Boolean.parseBoolean(temperatureString);
        boolean wind = windString == null ? true : Boolean.parseBoolean(windString);
        WorldProperties properties = new WorldProperties(dayLength, daysInSeason, ticks, temperature, wind);
        return properties;
    }
}

