/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.network;

import aiven.zomboidhealthsystem.ZomboidHealthSystemClient;
import aiven.zomboidhealthsystem.foundation.gui.hud.HealthHud;
import aiven.zomboidhealthsystem.foundation.items.BandageItem;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1792;

@Environment(value=EnvType.CLIENT)
public enum ClientTasks {
    DAMAGE((minecraftClient, clientPlayNetworkHandler, packetByteBuf, packetSender) -> minecraftClient.field_1724.method_5879(30.0f)),
    HEALTH((minecraftClient, clientPlayNetworkHandler, packetByteBuf, packetSender) -> {
        String health = packetByteBuf.method_19772();
        String[] names = new String[]{"head", "body", "left_arm", "right_arm", "left_leg", "right_leg", "left_foot", "right_foot"};
        int[] maxHps = new int[]{4, 6, 4, 4, 4, 4, 4, 4};
        byte[] hps = new byte[8];
        byte[] bandaged_body_parts = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] bleeding_body_parts = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] infection_body_parts = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        int playerHp = 100;
        for (int i = 0; i < 8; ++i) {
            String stringHp = JsonHelper.getValue(health, names[i], "hp");
            String bleeding = JsonHelper.getValue(health, names[i], "bleeding");
            String bandage = JsonHelper.getValue(health, names[i], "bandage item");
            String infection = JsonHelper.getValue(health, names[i], "infection");
            if (stringHp != null) {
                float hp = Float.parseFloat(stringHp);
                hps[i] = (byte)(hp / (float)maxHps[i] * 100.0f);
                if (hps[i] > 100) {
                    hps[i] = 110;
                }
            } else {
                hps[i] = 100;
            }
            boolean bl = false;
            if (bandage != null) {
                BandageItem item = (BandageItem)class_1792.method_7875((int)Integer.parseInt(bandage));
                bandaged_body_parts[i] = !item.isDirty() ? 1 : 2;
                if (!item.stopBleeding()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bleeding != null && bl) {
                bleeding_body_parts[i] = 1;
            }
            if (infection == null || !(Float.parseFloat(infection) > 6000.0f)) continue;
            infection_body_parts[i] = 1;
        }
        String value = JsonHelper.getValue(health, "player_hp");
        if (value != null) {
            playerHp = (int)Float.parseFloat(value);
        }
        int i = 0;
        for (HealthHud hud : HealthHud.values()) {
            hud.setHp(hps[i], bandaged_body_parts[i] != 0 && bandaged_body_parts[i] != 2);
            ++i;
        }
        ZomboidHealthSystemClient.INFECTION_BODY_PARTS = infection_body_parts;
        ZomboidHealthSystemClient.BANDAGED_BODY_PARTS = bandaged_body_parts;
        ZomboidHealthSystemClient.BLEEDING_BODY_PARTS = bleeding_body_parts;
        ZomboidHealthSystemClient.BODY_HEALTH = hps;
        ZomboidHealthSystemClient.PLAYER_HP = playerHp;
    }),
    WORLD((minecraftClient, clientPlayNetworkHandler, packetByteBuf, packetSender) -> {
        String data = packetByteBuf.method_19772();
        int[] temp = packetByteBuf.method_10787();
        boolean hasTemp = packetByteBuf.readBoolean();
        if (hasTemp) {
            ZomboidHealthSystemClient.AVERAGE_WORLD_TEMP = (float)Util.floor(Float.parseFloat(JsonHelper.getValue(data, "temperature")), 10);
            ZomboidHealthSystemClient.AVERAGE_SEASON_TEMP = (float)temp[0] / 10.0f;
            ZomboidHealthSystemClient.TEMPERATURE = (float)temp[2] / 10.0f;
        }
        ZomboidHealthSystemClient.DAY_LENGTH_MULTIPLIER = temp[1];
    });

    private final ClientPlayNetworking.PlayChannelHandler task;

    private ClientTasks(ClientPlayNetworking.PlayChannelHandler task) {
        this.task = task;
    }

    public ClientPlayNetworking.PlayChannelHandler get() {
        return this.task;
    }

    public static void initialize() {
    }
}

