/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import java.util.HashMap;
import net.minecraft.class_1291;

public abstract class AbstractCondition {
    public static int UPDATE_EVERY_TICKS = 5;
    final Health health;

    public AbstractCondition(Health health) {
        this.health = health;
    }

    abstract class_1291 getEffect();

    public abstract float getAmount();

    public abstract void setAmount(float var1);

    public abstract String getName();

    public boolean hasIcon() {
        return this.getAmount() >= 1.0f;
    }

    public void update() {
        if (!this.hasIcon()) {
            this.getHealth().clearEffect(this.getEffect());
        } else {
            this.getHealth().updateStatusEffect(this.getEffect(), Math.min((int)this.getAmount(), 10));
        }
    }

    boolean random(int time) {
        return Health.random(time);
    }

    public HashMap<String, String> getNbt() {
        HashMap<String, String> map = new HashMap<String, String>();
        float amount = this.getAmount();
        if (amount == 0.0f) {
            return null;
        }
        map.put(this.getName(), String.valueOf(amount));
        return map;
    }

    public void readNbt(String text) {
        String value = JsonHelper.getValue(text, this.getName());
        if (value != null) {
            this.setAmount(Float.parseFloat(value));
        } else {
            this.setAmount(0.0f);
        }
    }

    public Health getHealth() {
        return this.health;
    }

    public String toString() {
        return super.toString();
    }
}

