/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.player.conditions;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ModDamageTypes;
import aiven.zomboidhealthsystem.ModStatusEffects;
import aiven.zomboidhealthsystem.foundation.player.Health;
import aiven.zomboidhealthsystem.foundation.player.conditions.AbstractCondition;
import aiven.zomboidhealthsystem.foundation.utility.Util;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import aiven.zomboidhealthsystem.infrastructure.config.JsonHelper;
import java.util.HashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1294;

public class Drowsiness
extends AbstractCondition {
    public static int DROWSINESS_TIME = 24000 * ModServer.WORLD_PROPERTIES_ON_START.getDayLengthMultiplier();
    public class_1282 source = Util.getDamageSource(ModDamageTypes.DROWSINESS, this.getHealth().getPlayer());
    float amount = 0.0f;
    float caffeine = 0.0f;
    float max_caffeine = 0.0f;

    public Drowsiness(Health health) {
        super(health);
        DROWSINESS_TIME = 24000 * ModServer.getInstance().getProperties().getDayLengthMultiplier();
    }

    @Override
    class_1291 getEffect() {
        return ModStatusEffects.DROWSINESS;
    }

    @Override
    public float getAmount() {
        return this.amount;
    }

    @Override
    public String getName() {
        return "drowsiness";
    }

    @Override
    public void setAmount(float amount) {
        this.amount = amount;
    }

    @Override
    public HashMap<String, String> getNbt() {
        if (this.getAmount() != 0.0f || this.getCaffeine() != 0.0f || this.getMax_caffeine() != 0.0f) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (this.getAmount() != 0.0f) {
                map.put(this.getName(), String.valueOf(this.getAmount()));
            }
            if (this.getCaffeine() != 0.0f) {
                map.put("caffeine", String.valueOf(this.getCaffeine()));
            }
            if (this.getMax_caffeine() != 0.0f) {
                map.put("max_caffeine", String.valueOf(this.getMax_caffeine()));
            }
            return map;
        }
        return null;
    }

    @Override
    public void readNbt(String text) {
        String amount = JsonHelper.getValue(text, this.getName());
        String caffeine = JsonHelper.getValue(text, "caffeine");
        String max_caffeine = JsonHelper.getValue(text, "max_caffeine");
        if (amount != null) {
            float d = Float.parseFloat(amount);
            if (d < 5.0f) {
                this.setAmount(d);
            } else {
                this.setAmount(d / (float)DROWSINESS_TIME);
            }
        }
        if (caffeine != null && max_caffeine != null) {
            this.caffeine = Float.parseFloat(caffeine);
            this.max_caffeine = Float.parseFloat(max_caffeine);
        }
    }

    @Override
    public void update() {
        super.update();
        this.addTicks(1.0f * (this.getHealth().getExhaustion().getAmount() + 1.0f) * ConfigArgs.DROWSINESS_MULTIPLIER.getFloatValue().floatValue() * (float)UPDATE_EVERY_TICKS);
        if (this.caffeine > this.max_caffeine * -0.75f) {
            this.caffeine -= 1.0f / (float)DROWSINESS_TIME * 5.0f * 6.0f;
        }
        if (this.getAmplifier() >= 1.0f) {
            if (this.random((int)(6000.0f / this.getAmplifier()))) {
                this.getHealth().addStatusEffect(class_1294.field_5919, 1, 200);
            }
            this.getHealth().getExhaustion().addAmplifier(Float.valueOf(this.getAmplifier()));
            if (this.getAmplifier() >= 2.0f) {
                if (this.random((int)(6000.0f / (this.getAmplifier() / 2.0f))) && this.getHealth().getPlayer().method_6029() > 0.1f) {
                    this.getHealth().stumble();
                }
                if (this.getAmplifier() >= 3.0f) {
                    this.getHealth().updateStatusEffect(class_1294.field_5901, (int)(this.getAmplifier() / 2.0f));
                    if (this.getAmplifier() >= 5.0f) {
                        this.getHealth().onDeath(this.source);
                    }
                }
            }
        }
    }

    @Override
    public boolean hasIcon() {
        return this.getAmplifier() >= 1.0f;
    }

    public void onSleep() {
        this.max_caffeine = 0.0f;
        this.caffeine = 0.0f;
        this.amount = 0.0f;
    }

    public void addCaffeine(float amount) {
        this.caffeine += amount;
        this.max_caffeine += amount;
    }

    public boolean hasCaffeine() {
        return this.caffeine != 0.0f && this.max_caffeine != 0.0f;
    }

    public float getAmplifier() {
        return this.amount - this.caffeine;
    }

    public void addTicks(float amount) {
        this.amount += amount / (float)DROWSINESS_TIME;
    }

    public float getCaffeine() {
        return this.caffeine;
    }

    public float getMax_caffeine() {
        return this.max_caffeine;
    }
}

