/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.gui.hud;

import aiven.zomboidhealthsystem.ConfigArgs;
import aiven.zomboidhealthsystem.ZomboidHealthSystemClient;
import aiven.zomboidhealthsystem.foundation.gui.hud.Hud;
import aiven.zomboidhealthsystem.foundation.gui.screen.AbstractModScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Vector2f;

@Environment(value=EnvType.CLIENT)
public enum HealthHud {
    HEAD(16, 16, 10, 0),
    BODY(16, 30, 10, 18),
    LEFT_ARM(7, 30, 1, 18),
    RIGHT_ARM(7, 30, 28, 18),
    LEFT_LEG(7, 20, 10, 50),
    RIGHT_LEG(7, 20, 19, 50),
    LEFT_FOOT(7, 7, 10, 72),
    RIGHT_FOOT(7, 7, 19, 72);

    private final int width;
    private final int height;
    private final int x;
    private final int y;
    private int color = Colors.FULL_HEALTH_COLOR.getColor();
    private byte hp;
    private float ticks = 0.0f;
    private boolean healAnim = false;
    private final int borderColor = Colors.BORDER_COLOR.getColor();
    private int prevColor;
    boolean bl = false;
    public static Vector2f POS;

    private HealthHud(int width, int height, int x, int y) {
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
    }

    public void renderPart(class_332 context, float tickDelta, Vector2f pos) {
        int posX = (int)pos.x;
        int posY = (int)pos.y;
        Hud.DrawQuad(context, this.width, this.height, this.x + posX, this.y + posY, this.color, this.borderColor);
        if (this.healAnim) {
            if (!this.bl) {
                this.prevColor = this.color;
                this.bl = true;
            }
            this.setColor(Colors.WHITE.getColor());
            if (this.ticks > 5.0f) {
                this.ticks = 0.0f;
                this.bl = false;
                this.healAnim = false;
                this.setColor(this.prevColor);
            }
            this.ticks += tickDelta;
        }
    }

    private void setColor(int color) {
        this.color = color;
    }

    public void setHp(byte hp, boolean bandaged) {
        if (!bandaged) {
            if (hp > 100) {
                this.setColor(Colors.ADDITIONAL_HEALTH_COLOR.getColor());
            } else if (hp == 100) {
                this.setColor(Colors.FULL_HEALTH_COLOR.getColor());
            } else if (hp >= 90) {
                this.setColor(Colors.LITTLE_DAMAGED_HEALTH_COLOR.getColor());
            } else if (hp >= 75) {
                this.setColor(Colors.DAMAGED_HEALTH_COLOR.getColor());
            } else if (hp >= 50) {
                this.setColor(Colors.HALF_HEALTH_COLOR.getColor());
            } else if (hp >= 25) {
                this.setColor(Colors.VERY_DAMAGED_HEALTH_COLOR.getColor());
            } else if (hp > 0) {
                this.setColor(Colors.VERY_VERY_DAMAGED_HEALTH_COLOR.getColor());
            } else {
                this.setColor(Colors.NULL_HEALTH_COLOR.getColor());
            }
            if (hp > this.getHp() + 3) {
                this.healAnim = true;
            }
            this.hp = hp;
        } else {
            this.setColor(Colors.BANDAGED_BODY_PART.getColor());
        }
    }

    public byte getHp() {
        return this.hp;
    }

    public static void renderHud(class_332 context, float tickDelta, Vector2f pos) {
        try {
            class_310 client = class_310.method_1551();
            if (!(client.field_1724.method_7337() || client.field_1755 instanceof AbstractModScreen || ZomboidHealthSystemClient.DEBUG_INFO_RUN)) {
                for (HealthHud part : HealthHud.values()) {
                    part.renderPart(context, tickDelta, pos);
                }
            }
            ZomboidHealthSystemClient.DEBUG_INFO_RUN = false;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void render(class_332 context, float tickDelta, Vector2f pos) {
        for (HealthHud part : HealthHud.values()) {
            part.renderPart(context, tickDelta, pos);
        }
    }

    public static void savePos() {
        ConfigArgs.HUD_X.setValue((int)HealthHud.getPos().x);
        ConfigArgs.HUD_Y.setValue((int)HealthHud.getPos().y);
    }

    public static void setPos(Vector2f pos) {
        POS = pos;
    }

    public static Vector2f getPos() {
        return POS;
    }

    public static int getWidth() {
        return 35;
    }

    public static int getHeight() {
        return 73;
    }

    static {
        POS = new Vector2f((float)ConfigArgs.HUD_X.getIntegerValue().intValue(), (float)ConfigArgs.HUD_Y.getIntegerValue().intValue());
    }

    public static enum Colors {
        BANDAGED_BODY_PART(-1648211),
        ADDITIONAL_HEALTH_COLOR(-16384240),
        FULL_HEALTH_COLOR(-13338066),
        LITTLE_DAMAGED_HEALTH_COLOR(-3612672),
        DAMAGED_HEALTH_COLOR(-2053632),
        HALF_HEALTH_COLOR(-2064384),
        VERY_DAMAGED_HEALTH_COLOR(-2080256),
        VERY_VERY_DAMAGED_HEALTH_COLOR(0xFF00000),
        NULL_HEALTH_COLOR(-12434878),
        WHITE(-1),
        BORDER_COLOR(-15592942);

        private final int color;

        private Colors(int color) {
            this.color = color;
        }

        int getColor() {
            return this.color;
        }
    }
}

