/*
 * Decompiled with CFR 0.152.
 */
package aiven.zomboidhealthsystem.foundation.mixin;

import aiven.zomboidhealthsystem.ZomboidHealthSystem;
import aiven.zomboidhealthsystem.ZomboidHealthSystemServer;
import aiven.zomboidhealthsystem.foundation.world.ModServer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.BooleanSupplier;
import net.minecraft.class_3218;
import net.minecraft.class_3949;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class}, priority=1500)
public abstract class MinecraftServerMixin {
    @Shadow
    public abstract Path method_27050(class_5218 var1);

    @Shadow
    public abstract class_3218 method_30002();

    @Inject(at={@At(value="HEAD")}, method={"stop"})
    private void stop(boolean waitForShutdown, CallbackInfo ci) throws IOException {
        if (ModServer.getInstance() != null) {
            ModServer.getInstance().stop();
        }
    }

    @Unique
    public MinecraftServer toMinecraftServer() {
        return (MinecraftServer)this;
    }

    @Unique
    public String getPath() {
        return this.method_27050(class_5218.field_24182).toString().replaceAll("playerdata", "");
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        ModServer.getInstance().tick();
    }

    @Inject(at={@At(value="HEAD")}, method={"runServer"})
    public void runServer(CallbackInfo ci) throws IOException {
        if (ZomboidHealthSystem.isServer) {
            ZomboidHealthSystemServer.initialize();
        }
        new ModServer(this.toMinecraftServer(), this.getPath()).run();
    }

    @Inject(at={@At(value="TAIL")}, method={"createWorlds"})
    public void createWorlds(class_3949 worldGenerationProgressListener, CallbackInfo ci) throws IOException {
        ModServer.getInstance().loadOverworld(this.method_30002());
    }
}

