/*
 * Decompiled with CFR 0.152.
 */
package net.acidicts.chameleon.item.items;

import java.util.List;
import net.acidicts.chameleon.entity.ModEntities;
import net.acidicts.chameleon.entity.custom.ChameleonEntity;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ChameleonCapturer
extends class_1792 {
    private static final String ROOT = "Chameleon";
    private static final String NAME = "Name";
    private static final String VARIANT = "Variant";
    private static final String TYPE_VARIANT = "TypeVariant";
    private static final String AGE = "Age";
    private static final String HEALTH = "Health";

    public ChameleonCapturer(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (!(entity instanceof ChameleonEntity)) {
            return class_1269.field_5811;
        }
        ChameleonEntity chameleon = (ChameleonEntity)entity;
        if (user.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        if (this.hasChameleon(stack)) {
            return class_1269.field_5814;
        }
        class_2487 root = new class_2487();
        if (chameleon.method_16914()) {
            root.method_10582(NAME, chameleon.method_5797().getString());
        }
        root.method_10582(VARIANT, chameleon.getVariant().name());
        root.method_10569(TYPE_VARIANT, chameleon.getTypeVariant());
        root.method_10569(AGE, chameleon.method_5618());
        root.method_10548(HEALTH, chameleon.method_6032());
        class_2487 customData = new class_2487();
        customData.method_10566(ROOT, (class_2520)root);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customData));
        chameleon.method_31472();
        return class_1269.field_5812;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (world.field_9236) {
            return class_1271.method_22430((Object)stack);
        }
        if (this.hasChameleon(stack)) {
            class_239 hitResult = user.method_5745(5.0, 0.0f, false);
            if (hitResult.method_17783() != class_239.class_240.field_1332) {
                return class_1271.method_22431((Object)stack);
            }
            class_3965 blockHitResult = (class_3965)hitResult;
            class_2338 blockPos = blockHitResult.method_17777();
            class_243 spawnPos = class_243.method_24955((class_2382)blockPos).method_1031(0.0, 1.0, 0.0);
            ChameleonEntity chameleon = (ChameleonEntity)ModEntities.CHAMELEON.method_5883(world);
            if (chameleon == null) {
                return class_1271.method_22431((Object)stack);
            }
            class_9279 nbtComponent = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
            class_2487 root = nbtComponent.method_57461().method_10562(ROOT);
            if (root.method_10545(NAME)) {
                chameleon.method_5665(class_2561.method_30163((String)root.method_10558(NAME)));
                chameleon.method_5880(true);
            }
            class_2487 entityNbt = new class_2487();
            entityNbt.method_10569(VARIANT, root.method_10550(TYPE_VARIANT));
            chameleon.method_5749(entityNbt);
            chameleon.method_5614(root.method_10550(AGE));
            chameleon.method_6033(root.method_10583(HEALTH));
            chameleon.method_5808(spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, user.method_36454(), 0.0f);
            world.method_8649((class_1297)chameleon);
            stack.method_57381(class_9334.field_49628);
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    private boolean hasChameleon(class_1799 stack) {
        if (!stack.method_57826(class_9334.field_49628)) {
            return false;
        }
        class_9279 nbtComponent = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        return nbtComponent.method_57461().method_10545(ROOT);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (this.hasChameleon(stack)) {
            class_9279 nbtComponent = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
            class_2487 root = nbtComponent.method_57461().method_10562(ROOT);
            tooltip.add((class_2561)class_2561.method_43470((String)"Captured Chameleon").method_27692(class_124.field_1060));
            if (root.method_10545(NAME)) {
                tooltip.add((class_2561)class_2561.method_43470((String)"Name: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)root.method_10558(NAME)).method_27692(class_124.field_1068)));
            }
            tooltip.add((class_2561)class_2561.method_43470((String)"Variant: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)this.formatVariantName(root.method_10558(VARIANT))).method_27692(class_124.field_1075)));
            int age = root.method_10550(AGE);
            String ageText = age < 0 ? "Baby" : "Adult";
            tooltip.add((class_2561)class_2561.method_43470((String)"Age: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)ageText).method_27692(class_124.field_1054)));
            float health = root.method_10583(HEALTH);
            tooltip.add((class_2561)class_2561.method_43470((String)"Health: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.format("%.1f", Float.valueOf(health))).method_27692(class_124.field_1061)));
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43470((String)"Right Click to release").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"Empty").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43470((String)"Right Click a Chameleon to capture").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
        }
    }

    private String formatVariantName(String variant) {
        if (variant == null || variant.isEmpty()) {
            return "Unknown";
        }
        String[] parts = variant.toLowerCase().split("_");
        StringBuilder formatted = new StringBuilder();
        for (String part : parts) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
        }
        return formatted.toString();
    }
}

