/*
 * Decompiled with CFR 0.152.
 */
package better_end_sky.render;

import better_end_sky.Mod;
import better_end_sky.util.BackgroundInfo;
import better_end_sky.util.MHelper;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_1937;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class EndSkyRenderer
implements AutoCloseable {
    public static final int COLOR = -1;
    private static final class_2960 NEBULA_1 = Mod.id("textures/sky/nebula_2.png");
    private static final class_2960 NEBULA_2 = Mod.id("textures/sky/nebula_3.png");
    private static final class_2960 HORIZON = Mod.id("textures/sky/nebula_1.png");
    private static final class_2960 STARS = Mod.id("textures/sky/stars.png");
    private static final class_2960 FOG = Mod.id("textures/sky/fog.png");
    private GpuBuffer nebula1;
    private GpuBuffer nebula2;
    private GpuBuffer horizon;
    private GpuBuffer stars1;
    private GpuBuffer stars2;
    private GpuBuffer stars3;
    private GpuBuffer stars4;
    private GpuBuffer fog;
    private final Vector3f axis1;
    private final Vector3f axis2;
    private final Vector3f axis3;
    private final Vector3f axis4;
    private final class_310 client = class_310.method_1551();

    public EndSkyRenderer() {
        this.stars1 = this.buildBuffer(0.1f, 0.3f, 3500, 41315L, class_10799.field_56877, this::makeStars);
        this.stars2 = this.buildBuffer(0.1f, 0.35f, 2000, 35151L, class_10799.field_56877, this::makeStars);
        this.stars3 = this.buildBuffer(0.4f, 1.2f, 1000, 61354L, this::makeUVStars);
        this.stars4 = this.buildBuffer(0.4f, 1.2f, 1000, 61355L, this::makeUVStars);
        this.nebula1 = this.buildBuffer(40.0f, 60.0f, 30, 11515L, this::makeFarFog);
        this.nebula2 = this.buildBuffer(40.0f, 60.0f, 10, 14151L, this::makeFarFog);
        this.horizon = this.buildBufferHorizon();
        this.fog = this.buildBufferFog();
        class_5819 random = class_5819.method_43053();
        this.axis1 = new Vector3f(random.method_43057(), random.method_43057(), random.method_43057());
        this.axis2 = new Vector3f(random.method_43057(), random.method_43057(), random.method_43057());
        this.axis3 = new Vector3f(random.method_43057(), random.method_43057(), random.method_43057());
        this.axis4 = new Vector3f(random.method_43057(), random.method_43057(), random.method_43057());
        this.axis1.normalize();
        this.axis2.normalize();
        this.axis3.normalize();
        this.axis4.normalize();
    }

    public void render(class_1937 world, Matrix4f positionMatrix) {
        float a;
        if (world == null) {
            return;
        }
        class_4587 matrices = new class_4587();
        matrices.method_34425((Matrix4fc)positionMatrix);
        float time = ((float)world.method_8532() + this.client.method_61966().method_60638()) % 360000.0f * 1.7453292E-5f;
        float time2 = time * 2.0f;
        float blindnessFog = 1.0f - BackgroundInfo.blindness;
        float blindMod2 = blindnessFog * 0.2f;
        float blindMod6 = blindnessFog * 0.6f;
        if (blindnessFog > 0.0f) {
            matrices.method_22903();
            matrices.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, time, 0.0f));
            this.renderBuffer(matrices, HORIZON, this.horizon, class_10799.field_56875, 0.77f, 0.31f, 0.73f, 0.7f * blindnessFog);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, -time, 0.0f));
            this.renderBuffer(matrices, NEBULA_1, this.nebula1, class_10799.field_56875, 0.77f, 0.31f, 0.73f, blindMod2);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, time2, 0.0f));
            this.renderBuffer(matrices, NEBULA_2, this.nebula2, class_10799.field_56875, 0.77f, 0.31f, 0.73f, blindMod2);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907((Quaternionfc)new Quaternionf().setAngleAxis(time, this.axis3.x, this.axis3.y, this.axis3.z));
            this.renderBuffer(matrices, STARS, this.stars3, class_10799.field_56875, 0.77f, 0.31f, 0.73f, blindMod6);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907((Quaternionfc)new Quaternionf().setAngleAxis(time2, this.axis4.x, this.axis4.y, this.axis4.z));
            this.renderBuffer(matrices, STARS, this.stars4, class_10799.field_56875, 1.0f, 1.0f, 1.0f, blindMod6);
            matrices.method_22909();
        }
        if ((a = BackgroundInfo.fogDensity - 1.0f) > 0.0f) {
            if (a > 1.0f) {
                a = 1.0f;
            }
            this.renderBuffer(matrices, FOG, this.fog, class_10799.field_56875, BackgroundInfo.fogColorRed, BackgroundInfo.fogColorGreen, BackgroundInfo.fogColorBlue, a);
        }
        if (blindnessFog > 0.0f) {
            matrices.method_22903();
            matrices.method_22907((Quaternionfc)new Quaternionf().setAngleAxis(time * 3.0f, this.axis1.x, this.axis1.y, this.axis1.z));
            this.renderBuffer(matrices, HORIZON, this.stars1, class_10799.field_56877, 1.0f, 1.0f, 1.0f, blindMod6);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_22907((Quaternionfc)new Quaternionf().setAngleAxis(time2, this.axis2.x, this.axis2.y, this.axis2.z));
            this.renderBuffer(matrices, HORIZON, this.stars2, class_10799.field_56877, 0.95f, 0.64f, 0.93f, blindMod6);
            matrices.method_22909();
        }
        BackgroundInfo.blindness = 0.0f;
    }

    private void renderBuffer(class_4587 matrices, class_2960 textureId, GpuBuffer buffer, RenderPipeline pipeline, float r, float g, float b, float a) {
        class_1060 textureManager = this.client.method_1531();
        class_1044 texture = textureManager.method_4619(textureId);
        texture.method_70950(false);
        RenderSystem.class_5590 autoBuf = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)pipeline.getVertexFormatMode());
        GpuBuffer gpuBuffer = autoBuf.method_68274(buffer.size());
        GpuTextureView colorView = this.client.method_1522().method_71639();
        GpuTextureView depthView = this.client.method_1522().method_71640();
        GpuBufferSlice dynamicTransforms = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)matrices.method_23760().method_23761(), (Vector4fc)new Vector4f(r, g, b, a), (Vector3fc)RenderSystem.getModelOffset(), (Matrix4fc)RenderSystem.getTextureMatrix(), 1.0f);
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Better End sky", colorView, OptionalInt.empty(), depthView, OptionalDouble.empty());){
            pass.setPipeline(pipeline);
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setUniform("DynamicTransforms", dynamicTransforms);
            pass.bindSampler("Sampler0", texture.method_71659());
            pass.setVertexBuffer(0, buffer);
            pass.setIndexBuffer(gpuBuffer, autoBuf.method_31924());
            pass.drawIndexed(0, 0, gpuBuffer.size, 1);
        }
    }

    private GpuBuffer buildBuffer(float minSize, float maxSize, int count, long seed, RenderPipeline format, BufferFunction fkt) {
        GpuBuffer var10;
        try (class_9799 byteBufferBuilder = new class_9799(format.getVertexFormat().getVertexSize() * count * 4);){
            class_287 bufferBuilder = new class_287(byteBufferBuilder, format.getVertexFormatMode(), format.getVertexFormat());
            fkt.make(bufferBuilder, minSize, maxSize, count, seed);
            try (class_9801 meshData = bufferBuilder.method_60800();){
                var10 = RenderSystem.getDevice().createBuffer(() -> "Better End Sky vertex buffer", 40, meshData.method_60818());
            }
        }
        return var10;
    }

    private GpuBuffer buildBuffer(float minSize, float maxSize, int count, long seed, BufferFunction fkt) {
        return this.buildBuffer(minSize, maxSize, count, seed, class_10799.field_56875, fkt);
    }

    private GpuBuffer buildBufferHorizon() {
        return this.buildBuffer(0.0f, 0.0f, 0, 0L, (_builder, _minSize, _maxSize, _count, _seed) -> this.makeCylinder(_builder, 16, 50.0f, 180.0f));
    }

    private GpuBuffer buildBufferFog() {
        return this.buildBuffer(0.0f, 0.0f, 0, 0L, (_builder, _minSize, _maxSize, _count, _seed) -> this.makeCylinder(_builder, 16, 50.0f, 70.0f));
    }

    private void makeStars(class_287 buffer, float minSize, float maxSize, int count, long seed) {
        class_5820 random = new class_5820(seed);
        for (int i = 0; i < count; ++i) {
            float posX = random.method_43057() * 2.0f - 1.0f;
            float posY = random.method_43057() * 2.0f - 1.0f;
            float posZ = random.method_43057() * 2.0f - 1.0f;
            float size = MHelper.randRange(minSize, maxSize, (class_5819)random);
            float length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0f) || !(length > 0.001f)) continue;
            length = 1.0f / (float)Math.sqrt(length);
            float px = (posX *= length) * 100.0f;
            float py = (posY *= length) * 100.0f;
            float pz = (posZ *= length) * 100.0f;
            float angle = (float)Math.atan2(posX, posZ);
            float sin1 = (float)Math.sin(angle);
            float cos1 = (float)Math.cos(angle);
            angle = (float)Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            float sin2 = (float)Math.sin(angle);
            float cos2 = (float)Math.cos(angle);
            angle = random.method_43057() * (float)Math.PI * 2.0f;
            float sin3 = (float)Math.sin(angle);
            float cos3 = (float)Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                float x = (float)((index & 2) - 1) * size;
                float y = (float)((index + 1 & 2) - 1) * size;
                float aa = x * cos3 - y * sin3;
                float ab = y * cos3 + x * sin3;
                float dy = aa * sin2 + 0.0f * cos2;
                float ae = 0.0f * sin2 - aa * cos2;
                float dx = ae * sin1 - ab * cos1;
                float dz = ab * sin1 + ae * cos1;
                buffer.method_22912(px + dx, py + dy, pz + dz).method_39415(-1);
            }
        }
    }

    private void makeUVStars(class_287 buffer, float minSize, float maxSize, int count, long seed) {
        class_5820 random = new class_5820(seed);
        for (int i = 0; i < count; ++i) {
            float posX = random.method_43057() * 2.0f - 1.0f;
            float posY = random.method_43057() * 2.0f - 1.0f;
            float posZ = random.method_43057() * 2.0f - 1.0f;
            float size = MHelper.randRange(minSize, maxSize, (class_5819)random);
            float length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0f) || !(length > 0.001f)) continue;
            length = 1.0f / (float)Math.sqrt(length);
            float px = (posX *= length) * 100.0f;
            float py = (posY *= length) * 100.0f;
            float pz = (posZ *= length) * 100.0f;
            float angle = (float)Math.atan2(posX, posZ);
            float sin1 = (float)Math.sin(angle);
            float cos1 = (float)Math.cos(angle);
            angle = (float)Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            float sin2 = (float)Math.sin(angle);
            float cos2 = (float)Math.cos(angle);
            angle = random.method_43057() * (float)Math.PI * 2.0f;
            float sin3 = (float)Math.sin(angle);
            float cos3 = (float)Math.cos(angle);
            float minV = (float)random.method_43048(4) / 4.0f;
            for (int index = 0; index < 4; ++index) {
                float x = (float)((index & 2) - 1) * size;
                float y = (float)((index + 1 & 2) - 1) * size;
                float aa = x * cos3 - y * sin3;
                float ab = y * cos3 + x * sin3;
                float dy = aa * sin2 + 0.0f * cos2;
                float ae = 0.0f * sin2 - aa * cos2;
                float dx = ae * sin1 - ab * cos1;
                float dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = (float)(index + 1 >> 1 & 1) / 4.0f + minV;
                buffer.method_22912(px + dx, py + dy, pz + dz).method_22913(texU, texV).method_39415(-1);
            }
        }
    }

    private void makeFarFog(class_287 buffer, float minSize, float maxSize, int count, long seed) {
        class_5820 random = new class_5820(seed);
        for (int i = 0; i < count; ++i) {
            float posX = random.method_43057() * 2.0f - 1.0f;
            float posY = random.method_43057() - 0.5f;
            float posZ = random.method_43057() * 2.0f - 1.0f;
            float size = MHelper.randRange(minSize, maxSize, (class_5819)random);
            float length = posX * posX + posY * posY + posZ * posZ;
            float distance = 2.0f;
            if (!(length < 1.0f) || !(length > 0.001f)) continue;
            length = distance / (float)Math.sqrt(length);
            size *= distance;
            float px = (posX *= length) * 100.0f;
            float py = (posY *= length) * 100.0f;
            float pz = (posZ *= length) * 100.0f;
            float angle = (float)Math.atan2(posX, posZ);
            float sin1 = (float)Math.sin(angle);
            float cos1 = (float)Math.cos(angle);
            angle = (float)Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            float sin2 = (float)Math.sin(angle);
            float cos2 = (float)Math.cos(angle);
            angle = random.method_43057() * (float)Math.PI * 2.0f;
            float sin3 = (float)Math.sin(angle);
            float cos3 = (float)Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                float x = (float)((index & 2) - 1) * size;
                float y = (float)((index + 1 & 2) - 1) * size;
                float aa = x * cos3 - y * sin3;
                float ab = y * cos3 + x * sin3;
                float dy = aa * sin2 + 0.0f * cos2;
                float ae = 0.0f * sin2 - aa * cos2;
                float dx = ae * sin1 - ab * cos1;
                float dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = index + 1 >> 1 & 1;
                buffer.method_22912(px + dx, py + dy, pz + dz).method_22913(texU, texV).method_39415(-1);
            }
        }
    }

    private void makeCylinder(class_287 buffer, int segments, float height, float radius) {
        for (int i = 0; i < segments; ++i) {
            float a1 = (float)i * (float)Math.PI * 2.0f / (float)segments;
            float a2 = (float)(i + 1) * (float)Math.PI * 2.0f / (float)segments;
            float px1 = (float)Math.sin(a1) * radius;
            float pz1 = (float)Math.cos(a1) * radius;
            float px2 = (float)Math.sin(a2) * radius;
            float pz2 = (float)Math.cos(a2) * radius;
            float u0 = (float)i / (float)segments;
            float u1 = (float)(i + 1) / (float)segments;
            buffer.method_22912(px1, -height, pz1).method_22913(u0, 0.0f).method_39415(-1);
            buffer.method_22912(px1, height, pz1).method_22913(u0, 1.0f).method_39415(-1);
            buffer.method_22912(px2, height, pz2).method_22913(u1, 1.0f).method_39415(-1);
            buffer.method_22912(px2, -height, pz2).method_22913(u1, 0.0f).method_39415(-1);
        }
    }

    @Override
    public void close() {
        this.nebula1.close();
        this.nebula2.close();
        this.horizon.close();
        this.stars1.close();
        this.stars2.close();
        this.stars3.close();
        this.stars4.close();
    }

    @FunctionalInterface
    static interface BufferFunction {
        public void make(class_287 var1, float var2, float var3, int var4, long var5);
    }
}

