/*
 * Decompiled with CFR 0.152.
 */
package com.flare.bumblewarps.commands;

import com.flare.bumblewarps.BumbleWarps;
import com.flare.bumblewarps.utils.MessageUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WarpCommand
implements CommandExecutor {
    private final BumbleWarps plugin;

    public WarpCommand(BumbleWarps plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("bwarps.command.players")) {
            player.sendMessage(MessageUtil.format(this.plugin, "no-permission"));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage("\u00a7eUsage: /warp <name>");
            return true;
        }
        String warpName = args[0];
        Location warp = this.plugin.getWarpManager().getWarp(warpName);
        if (warp == null) {
            player.sendMessage(MessageUtil.replace(MessageUtil.format(this.plugin, "warp-not-found"), "%warp%", warpName));
            return true;
        }
        player.sendMessage(MessageUtil.replace(MessageUtil.format(this.plugin, "warp-teleport"), "%warp%", warpName));
        int delay = this.plugin.getConfig().getInt("teleport-delay", 0);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> player.teleport(warp), (long)delay * 20L);
        return true;
    }
}

