/*
 * Decompiled with CFR 0.152.
 */
package com.flare.bumblewarps.data;

import com.flare.bumblewarps.BumbleWarps;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public class WarpManager {
    private final BumbleWarps plugin;
    private final Map<String, Location> warps = new HashMap<String, Location>();

    public WarpManager(BumbleWarps plugin) {
        this.plugin = plugin;
    }

    public void setWarp(String name, Location loc) {
        this.warps.put(name.toLowerCase(), loc);
        this.saveWarps();
    }

    public void delWarp(String name) {
        this.warps.remove(name.toLowerCase());
        this.saveWarps();
    }

    public boolean renameWarp(String oldName, String newName) {
        Location loc = this.warps.remove(oldName.toLowerCase());
        if (loc != null) {
            this.warps.put(newName.toLowerCase(), loc);
            this.saveWarps();
            return true;
        }
        return false;
    }

    public Location getWarp(String name) {
        return this.warps.get(name.toLowerCase());
    }

    public boolean warpExists(String name) {
        return this.warps.containsKey(name.toLowerCase());
    }

    public void loadWarps() {
        this.warps.clear();
        FileConfiguration config = this.plugin.getConfig();
        if (!config.isConfigurationSection("warps")) {
            return;
        }
        for (String name : config.getConfigurationSection("warps").getKeys(false)) {
            String path = "warps." + name;
            World world = Bukkit.getWorld((String)config.getString(path + ".world"));
            if (world == null) continue;
            double x = config.getDouble(path + ".x");
            double y = config.getDouble(path + ".y");
            double z = config.getDouble(path + ".z");
            float yaw = (float)config.getDouble(path + ".yaw");
            float pitch = (float)config.getDouble(path + ".pitch");
            Location loc = new Location(world, x, y, z, yaw, pitch);
            this.warps.put(name.toLowerCase(), loc);
        }
    }

    public void saveWarps() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("warps", null);
        for (Map.Entry<String, Location> entry : this.warps.entrySet()) {
            String path = "warps." + entry.getKey();
            Location loc = entry.getValue();
            config.set(path + ".world", (Object)loc.getWorld().getName());
            config.set(path + ".x", (Object)loc.getX());
            config.set(path + ".y", (Object)loc.getY());
            config.set(path + ".z", (Object)loc.getZ());
            config.set(path + ".yaw", (Object)Float.valueOf(loc.getYaw()));
            config.set(path + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        }
        this.plugin.saveConfig();
    }

    public Map<String, Location> getWarps() {
        return this.warps;
    }
}

