/*
 * Decompiled with CFR 0.152.
 */
package de.aaronbeier.obsidiantnt;

import de.aaronbeier.obsidiantnt.relocated.morepersistentdatatypes.DataType;
import de.aaronbeier.obsidiantnt.relocated.morepersistentdatatypes.datatypes.collections.CollectionDataType;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.BlockVector;

public final class ObsidianTntPlugin
extends JavaPlugin
implements Listener {
    private static final CollectionDataType<HashSet<BlockVector>, BlockVector> bedrockBreakerLocationSetDataType = DataType.asHashSet(DataType.BLOCK_VECTOR);
    private static final Random random = new Random();
    private static final int[][] directionsToCheck = new int[][]{{0, 0, -1}, {1, 0, 0}, {0, 0, 1}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}};
    final NamespacedKey bedrockBreakerKey = new NamespacedKey((Plugin)this, "bedrock_breaker");
    final NamespacedKey hasSeenGunpowderKey = new NamespacedKey((Plugin)this, "gunpowder");
    final NamespacedKey hasSeenObsidianKey = new NamespacedKey((Plugin)this, "obsidian");

    public void onEnable() {
        ItemStack bedrockBreakerItem = new ItemStack(Material.TNT);
        bedrockBreakerItem.editMeta(meta -> {
            meta.itemName(Component.text((String)"Obsidian TNT").decoration(TextDecoration.ITALIC, false));
            meta.setRarity(ItemRarity.UNCOMMON);
            meta.lore(List.of((TextComponent)Component.text((String)"A block of TNT reinforced with obsidian.", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"This might be able to blow up bedrock...", (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
            meta.setCustomModelData(Integer.valueOf(7177));
            meta.getPersistentDataContainer().set(this.bedrockBreakerKey, PersistentDataType.BOOLEAN, (Object)true);
        });
        ShapedRecipe bedrockBreakerRecipe = new ShapedRecipe(this.bedrockBreakerKey, bedrockBreakerItem);
        bedrockBreakerRecipe.shape(new String[]{"OTO", "TOT", "OTO"});
        bedrockBreakerRecipe.setIngredient('O', Material.OBSIDIAN);
        bedrockBreakerRecipe.setIngredient('T', Material.TNT);
        bedrockBreakerRecipe.setCategory(CraftingBookCategory.REDSTONE);
        Bukkit.addRecipe((Recipe)bedrockBreakerRecipe);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onPlayerPickupIItem(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Material material = event.getItem().getItemStack().getType();
        if (material != Material.GUNPOWDER && material != Material.OBSIDIAN) {
            return;
        }
        PersistentDataContainer playerData = player.getPersistentDataContainer();
        boolean hasSeenGunpowder = playerData.has(this.hasSeenGunpowderKey);
        boolean hasSeenObsidian = playerData.has(this.hasSeenObsidianKey);
        if (hasSeenGunpowder && hasSeenObsidian) {
            return;
        }
        switch (material) {
            case GUNPOWDER: {
                if (!playerData.has(this.hasSeenGunpowderKey)) {
                    playerData.set(this.hasSeenGunpowderKey, PersistentDataType.BOOLEAN, (Object)true);
                }
                hasSeenGunpowder = true;
                break;
            }
            case OBSIDIAN: {
                if (!playerData.has(this.hasSeenObsidianKey)) {
                    playerData.set(this.hasSeenObsidianKey, PersistentDataType.BOOLEAN, (Object)true);
                }
                hasSeenObsidian = true;
                break;
            }
            default: {
                throw new RuntimeException("this should be unreachable");
            }
        }
        if (hasSeenGunpowder && hasSeenObsidian) {
            player.discoverRecipe(this.bedrockBreakerKey);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onBlockPlace(BlockPlaceEvent event) {
        ItemStack stack = event.getItemInHand();
        if (!stack.hasItemMeta()) {
            return;
        }
        PersistentDataContainerView stackPersistentData = stack.getPersistentDataContainer();
        if (!((Boolean)stackPersistentData.getOrDefault(this.bedrockBreakerKey, PersistentDataType.BOOLEAN, (Object)false)).booleanValue()) {
            return;
        }
        Block block = event.getBlockPlaced();
        PersistentDataContainer worldPersistentData = block.getWorld().getPersistentDataContainer();
        HashSet bedrockBreakerLocations = (HashSet)worldPersistentData.getOrDefault(this.bedrockBreakerKey, bedrockBreakerLocationSetDataType, new HashSet());
        bedrockBreakerLocations.add(new BlockVector(block.getX(), block.getY(), block.getZ()));
        worldPersistentData.set(this.bedrockBreakerKey, bedrockBreakerLocationSetDataType, (Object)bedrockBreakerLocations);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        PersistentDataContainer worldPersistentData = block.getWorld().getPersistentDataContainer();
        HashSet bedrockBreakerLocations = (HashSet)worldPersistentData.getOrDefault(this.bedrockBreakerKey, bedrockBreakerLocationSetDataType, new HashSet());
        bedrockBreakerLocations.remove(new BlockVector(block.getX(), block.getY(), block.getZ()));
        worldPersistentData.set(this.bedrockBreakerKey, bedrockBreakerLocationSetDataType, (Object)bedrockBreakerLocations);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onEntityExplode(EntityExplodeEvent event) {
        BlockVector positionToCheck;
        Entity entity = event.getEntity();
        if (!(entity instanceof TNTPrimed)) {
            return;
        }
        TNTPrimed primedTnt = (TNTPrimed)entity;
        Location sourceLocation = primedTnt.getOrigin();
        if (sourceLocation == null) {
            return;
        }
        World world = primedTnt.getWorld();
        PersistentDataContainer worldPersistentData = world.getPersistentDataContainer();
        HashSet bedrockBreakerLocations = (HashSet)worldPersistentData.getOrDefault(this.bedrockBreakerKey, bedrockBreakerLocationSetDataType, new HashSet());
        if (!bedrockBreakerLocations.contains(positionToCheck = new BlockVector(sourceLocation.getBlockX(), sourceLocation.getBlockY(), sourceLocation.getBlockZ()))) {
            return;
        }
        bedrockBreakerLocations.remove(positionToCheck);
        worldPersistentData.set(this.bedrockBreakerKey, bedrockBreakerLocationSetDataType, (Object)bedrockBreakerLocations);
        for (int[] direction : directionsToCheck) {
            Block block = world.getBlockAt(sourceLocation.clone().add((double)direction[0], (double)direction[1], (double)direction[2]));
            if (block.getType() != Material.BEDROCK || !(random.nextFloat() > 0.2f)) continue;
            block.setType(Material.AIR);
        }
    }
}

