/*
 * Decompiled with CFR 0.152.
 */
package tech.encrusted.breadcrumbs;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import net.minecraft.class_9801;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;
import tech.encrusted.breadcrumbs.CatmullRomSpline;
import tech.encrusted.breadcrumbs.config.Settings;
import tech.encrusted.breadcrumbs.config.TrailMode;

@Environment(value=EnvType.CLIENT)
public class Breadcrumbs
implements ClientModInitializer {
    private static boolean enabled = false;
    private static List<Vector3f> positions = new ArrayList<Vector3f>();
    private static List<Vector3f> points = new ArrayList<Vector3f>();
    private static class_304 keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.breadcrumbs.toggle", class_3675.class_307.field_1668, 93, "key.breadcrumbs.category"));
    public static Settings settings;
    private static final float saturation = 1.0f;
    private static final float brightness = 1.0f;

    public void onInitializeClient() {
        AutoConfig.register(Settings.class, Settings.factory);
        settings = (Settings)AutoConfig.getConfigHolder(Settings.class).getConfig();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (keyBinding.method_1436()) {
                boolean bl = enabled = !enabled;
                if (enabled) {
                    positions.clear();
                }
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Recording: " + enabled)), false);
            }
        });
        WorldRenderEvents.LAST.register(context -> {
            Vector3f pos2;
            if (!enabled) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (class_310.method_1551().method_1493()) {
                return;
            }
            if (player == null) {
                enabled = false;
                return;
            }
            Vector3f playerPos = player.method_30950(class_310.method_1551().method_61966().method_60637(false)).method_46409().add(0.0f, 0.1f, 0.0f);
            if (Breadcrumbs.settings.removeLoops) {
                Breadcrumbs.detectAndRemoveLoops(playerPos);
            }
            if (positions.size() < 2) {
                this.addPosition(playerPos);
                return;
            }
            Vector3f pos1 = positions.get(positions.size() - 1);
            if (pos1.distance((Vector3fc)(pos2 = positions.get(positions.size() - 2))) < Breadcrumbs.settings.segmentLength) {
                positions.remove(pos1);
                this.addPosition(playerPos);
                return;
            }
            this.addPosition(playerPos);
        });
        WorldRenderEvents.LAST.register(context -> {
            int size = points.size();
            if (size == 0) {
                return;
            }
            Matrix4f matrix = context.matrixStack().method_23760().method_23761();
            if (Breadcrumbs.settings.renderThroughWalls) {
                RenderSystem.disableDepthTest();
            } else {
                RenderSystem.enableDepthTest();
            }
            class_289 tessellator = class_289.method_1348();
            class_243 cameraPos = context.camera().method_19326();
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            GL11.glDisable((int)2884);
            RenderSystem.enableBlend();
            if (Breadcrumbs.settings.trailMode == TrailMode.LINES) {
                boolean arrows = Breadcrumbs.settings.renderArrows;
                class_287 buf = arrows ? tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576) : tessellator.method_60827(class_293.class_5596.field_29345, class_290.field_1576);
                Breadcrumbs.drawLineTrail(size, arrows, buf, matrix, cameraPos);
                class_9801 buffer = buf.method_60800();
                if (size - (arrows ? 1 : 0) > 0) {
                    class_286.method_43433((class_9801)buffer);
                }
            } else if (Breadcrumbs.settings.trailMode == TrailMode.THICK) {
                class_287 buf = tessellator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
                Breadcrumbs.drawThickTrail(size, buf, matrix, cameraPos);
                if (size - 1 > 0) {
                    class_9801 buffer = buf.method_60800();
                    class_286.method_43433((class_9801)buffer);
                }
            }
            RenderSystem.disableBlend();
            GL11.glEnable((int)2884);
            RenderSystem.enableDepthTest();
        });
    }

    private static void drawLineTrail(int size, boolean arrows, class_287 buf, Matrix4f matrix, class_243 cameraPos) {
        for (int i = 0; i < size - (arrows ? 1 : 0); ++i) {
            float[] color = (positions.size() - 1) * Breadcrumbs.settings.interpolationSteps >= size ? Breadcrumbs.getColor(i, size + Breadcrumbs.settings.interpolationSteps) : Breadcrumbs.getColor(i, size);
            Vector3f pos1 = points.get(i);
            Breadcrumbs.vertex(buf, matrix, pos1, cameraPos, color);
            if (!arrows) continue;
            Vector3f pos2 = points.get(i + 1);
            Breadcrumbs.vertex(buf, matrix, pos2, cameraPos, color);
            if (i != size - 2 && (!Breadcrumbs.settings.smoothInterpolation || i / Breadcrumbs.settings.interpolationSteps % Breadcrumbs.settings.arrowFrequency != 0 || i % Breadcrumbs.settings.interpolationSteps != 0) && (Breadcrumbs.settings.smoothInterpolation || i % Breadcrumbs.settings.arrowFrequency != 0)) continue;
            Vector3f dir = new Vector3f((Vector3fc)pos2).sub((Vector3fc)pos1).normalize();
            float pitch = (float)Math.asin(-dir.y);
            float yaw = (float)Math.atan2(dir.x, dir.z);
            Matrix3f rotation = new Matrix3f();
            rotation.rotateYXZ(yaw, pitch, 0.0f);
            if (Breadcrumbs.settings.backwardsArrows) {
                rotation.rotateY((float)Math.PI);
            }
            Vector3f arrowLeft = new Vector3f(-Breadcrumbs.settings.arrowSize, 0.0f, -2.0f * Breadcrumbs.settings.arrowSize).mul((Matrix3fc)rotation).add((Vector3fc)pos2);
            Vector3f arrowRight = new Vector3f(Breadcrumbs.settings.arrowSize, 0.0f, -2.0f * Breadcrumbs.settings.arrowSize).mul((Matrix3fc)rotation).add((Vector3fc)pos2);
            Breadcrumbs.vertex(buf, matrix, pos2, cameraPos, color);
            Breadcrumbs.vertex(buf, matrix, arrowLeft, cameraPos, color);
            Breadcrumbs.vertex(buf, matrix, pos2, cameraPos, color);
            Breadcrumbs.vertex(buf, matrix, arrowRight, cameraPos, color);
        }
    }

    private static void drawThickTrail(int size, class_287 buf, Matrix4f matrix, class_243 cameraPos) {
        double oldAngle = 0.0;
        boolean swapped = false;
        for (int i = 0; i < size - 1; ++i) {
            float[] color = (positions.size() - 1) * Breadcrumbs.settings.interpolationSteps >= size ? Breadcrumbs.getColor(i, size + Breadcrumbs.settings.interpolationSteps) : Breadcrumbs.getColor(i, size);
            Vector3f pos1 = points.get(i);
            Vector3f pos2 = Breadcrumbs.equalify(pos1, points.get(i + 1));
            double angle = Math.atan2(pos2.x - pos1.x, pos2.z - pos1.z);
            double a0 = angle + 1.5707963267948966;
            double a1 = angle - 1.5707963267948966;
            int arrowFrequency = Breadcrumbs.settings.arrowFrequency;
            float thickness = Breadcrumbs.getSegmentThickness(i, arrowFrequency *= Breadcrumbs.settings.smoothInterpolation ? Breadcrumbs.settings.interpolationSteps : 1);
            Vector3f p1 = new Vector3f((float)Math.sin(a0), 0.0f, (float)Math.cos(a0)).mul(thickness).add((Vector3fc)pos2);
            Vector3f p2 = new Vector3f((float)Math.sin(a1), 0.0f, (float)Math.cos(a1)).mul(thickness).add((Vector3fc)pos2);
            if (Math.cos(angle - oldAngle) < 0.0) {
                boolean bl = swapped = !swapped;
            }
            if (swapped) {
                Breadcrumbs.vertex(buf, matrix, p1, cameraPos, color);
                Breadcrumbs.vertex(buf, matrix, p2, cameraPos, color);
            } else {
                Breadcrumbs.vertex(buf, matrix, p2, cameraPos, color);
                Breadcrumbs.vertex(buf, matrix, p1, cameraPos, color);
            }
            if (i % arrowFrequency == arrowFrequency - 1 && Breadcrumbs.settings.renderArrows) {
                p1 = new Vector3f((float)Math.sin(a0), 0.0f, (float)Math.cos(a0)).mul(Breadcrumbs.settings.arrowSize + Breadcrumbs.settings.trailThickness).add((Vector3fc)pos2);
                p2 = new Vector3f((float)Math.sin(a1), 0.0f, (float)Math.cos(a1)).mul(Breadcrumbs.settings.arrowSize + Breadcrumbs.settings.trailThickness).add((Vector3fc)pos2);
                Breadcrumbs.vertex(buf, matrix, p1, cameraPos, color);
                Breadcrumbs.vertex(buf, matrix, p2, cameraPos, color);
            }
            oldAngle = angle;
        }
    }

    private static Vector3f equalify(Vector3f v1, Vector3f v2) {
        int x1 = Float.floatToIntBits(v1.x);
        int y1 = Float.floatToIntBits(v1.y);
        int z1 = Float.floatToIntBits(v1.z);
        int x2 = Float.floatToIntBits(v2.x);
        int y2 = Float.floatToIntBits(v2.y);
        int z2 = Float.floatToIntBits(v2.z);
        if (Math.abs(x1 - x2) <= 1) {
            v2.x = v1.x;
        }
        if (Math.abs(y1 - y2) <= 1) {
            v2.y = v1.y;
        }
        if (Math.abs(z1 - z2) <= 1) {
            v2.z = v1.z;
        }
        return v2;
    }

    private static void vertex(class_287 buf, Matrix4f matrix, Vector3f pos1, class_243 cameraPos, float[] color) {
        buf.method_22918(matrix, (float)((double)pos1.x - cameraPos.field_1352), (float)((double)pos1.y - cameraPos.field_1351), (float)((double)pos1.z - cameraPos.field_1350)).method_22915(color[0], color[1], color[2], Breadcrumbs.settings.trailOpacity);
    }

    private static float getSegmentThickness(int i, int arrowFrequency) {
        float thickness = Breadcrumbs.settings.renderArrows ? (Breadcrumbs.settings.backwardsArrows ? (Breadcrumbs.settings.arrowSize + Breadcrumbs.settings.trailThickness) * (float)(i % arrowFrequency) / (float)(arrowFrequency + 1) : (Breadcrumbs.settings.arrowSize + Breadcrumbs.settings.trailThickness) * (float)(arrowFrequency - i % arrowFrequency) / (float)(arrowFrequency + 1)) : Breadcrumbs.settings.trailThickness;
        return thickness;
    }

    private static float[] getColor(float i, int size) {
        float hue = i / (float)Math.max(size, 30) * 0.5f;
        return new Color(Color.HSBtoRGB(hue, 1.0f, 1.0f)).getRGBComponents(null);
    }

    private static void detectAndRemoveLoops(Vector3f playerPos) {
        if (positions.size() > 3) {
            float loopThreshold = 2.0f;
            int closePointIndex = -1;
            int i = 0;
            while ((double)i < (double)positions.size() - Math.ceil(Math.max(1.0f, 1.0f / Breadcrumbs.settings.segmentLength)) * 3.0) {
                if (playerPos.distance((Vector3fc)positions.get(i)) < loopThreshold) {
                    closePointIndex = i;
                    break;
                }
                ++i;
            }
            if (closePointIndex >= 0) {
                while (positions.size() > closePointIndex + 1) {
                    positions.remove(positions.size() - 1);
                }
            }
        }
    }

    private void addPosition(Vector3f playerPos) {
        positions.add(playerPos);
        points = Breadcrumbs.settings.smoothInterpolation ? CatmullRomSpline.interpolate(positions, Breadcrumbs.settings.interpolationSteps) : positions;
    }
}

