/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class InteractionOverrideProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<class_2960, Builder<?>> data = new HashMap();
    private final class_2403 gen;

    public InteractionOverrideProvider(class_2403 gen) {
        this.gen = gen;
    }

    protected abstract void add();

    public void method_10319(class_2408 cache) {
        this.add();
        this.data.forEach((res, data) -> {
            Path path = this.gen.method_10313().resolve("data/" + res.method_12836() + "/claim_interactions_override/" + res.method_12832() + ".json");
            try {
                JsonObject obj = new JsonObject();
                obj.addProperty("type", data.type.id().toString());
                obj.add("values", data.values());
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save itemstat {}", (Object)path, (Object)e);
            }
        });
    }

    public String method_10321() {
        return "Interaction Overrides";
    }

    public <T> void override(class_2960 res, Builder<T> permission) {
        if (this.data.put(res, permission) != null) {
            throw new IllegalStateException("Override already exists" + String.valueOf(res));
        }
    }

    public static class Builder<T> {
        private static final Codec<List<Pair<Either<class_6862<class_2248>, class_2960>, class_2960>>> BLOCK_CODEC = InteractionOverrideManager.tagOrEntryCodec(class_2378.field_25105, class_2960.field_25139).listOf();
        private static final Codec<List<Pair<Either<class_6862<class_1792>, class_2960>, class_2960>>> ITEM_CODEC = InteractionOverrideManager.tagOrEntryCodec(class_2378.field_25108, class_2960.field_25139).listOf();
        private static final Codec<List<Pair<Either<class_6862<class_1299<?>>, class_2960>, class_2960>>> ENTITY_CODEC = InteractionOverrideManager.tagOrEntryCodec(class_2378.field_25107, class_2960.field_25139).listOf();
        public final InteractionOverrideManager.InteractionType<T> type;
        private final class_2378<T> registry;
        private final Codec<List<Pair<Either<class_6862<T>, class_2960>, class_2960>>> codec;
        private final List<Pair<Either<class_6862<T>, class_2960>, class_2960>> entries = new ArrayList<Pair<Either<class_6862<T>, class_2960>, class_2960>>();

        private Builder(InteractionOverrideManager.InteractionType<T> type, class_2378<T> registry, Codec<List<Pair<Either<class_6862<T>, class_2960>, class_2960>>> codec) {
            this.type = type;
            this.registry = registry;
            this.codec = codec;
        }

        public static Builder<class_2248> blockInteractions(InteractionOverrideManager.InteractionType<class_2248> type) {
            if (type != InteractionOverrideManager.BLOCK_LEFT_CLICK && type != InteractionOverrideManager.BLOCK_INTERACT) {
                throw new IllegalStateException("Unsupported Type");
            }
            return new Builder<class_2248>(type, (class_2378<class_2248>)class_2378.field_11146, BLOCK_CODEC);
        }

        public static Builder<class_1792> itemInteractions(InteractionOverrideManager.InteractionType<class_1792> type) {
            if (type != InteractionOverrideManager.ITEM_USE) {
                throw new IllegalStateException("Unsupported Type");
            }
            return new Builder<class_1792>(type, (class_2378<class_1792>)class_2378.field_11142, ITEM_CODEC);
        }

        public static Builder<class_1299<?>> entityInteractions(InteractionOverrideManager.InteractionType<class_1299<?>> type) {
            if (type != InteractionOverrideManager.ENTITY_ATTACK && type != InteractionOverrideManager.ENTITY_INTERACT) {
                throw new IllegalStateException("Unsupported Type");
            }
            return new Builder(type, (class_2378<class_1299<?>>)class_2378.field_11145, ENTITY_CODEC);
        }

        public Builder<T> addEntry(T value, class_2960 permission) {
            this.entries.add(Pair.of((Object)Either.right((Object)this.registry.method_10221(value)), (Object)permission));
            return this;
        }

        public Builder<T> addEntry(class_2960 value, class_2960 permission) {
            this.entries.add(Pair.of((Object)Either.right((Object)value), (Object)permission));
            return this;
        }

        public Builder<T> addEntry(class_6862<T> value, class_2960 permission) {
            this.entries.add(Pair.of((Object)Either.left(value), (Object)permission));
            return this;
        }

        protected JsonElement values() {
            return (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow(false, x$0 -> Flan.error(x$0, new Object[0]));
        }
    }
}

