/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.claim;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class AllowedRegistryList<T> {
    public static final Function<class_1299<?>, class_1792> ENTITY_AS_ITEM = type -> {
        class_1826 egg = class_1826.method_8019((class_1299)type);
        return egg != null ? egg : class_1802.field_8493;
    };
    private final Map<String, Integer> mapping = new HashMap<String, Integer>();
    private final List<Either<T, class_6862<T>>> list = new ArrayList<Either<T, class_6862<T>>>();
    private final class_2378<T> registry;
    private final Claim claim;
    private final Function<T, class_1792> asItem;

    public AllowedRegistryList(class_2378<T> registry, Claim claim, Function<T, class_1792> asItem) {
        this.registry = registry;
        this.claim = claim;
        this.asItem = asItem;
    }

    public static <T extends class_1935> AllowedRegistryList<T> ofItemLike(class_2378<T> registry, Claim claim) {
        return new AllowedRegistryList<class_1935>(registry, claim, class_1935::method_8389);
    }

    public List<class_1799> asStacks() {
        return this.list.stream().map(e -> (class_1799)e.map(v -> new class_1799((class_1935)this.asItem.apply(v)), tag -> {
            class_1799 any = this.registry.method_40266(tag).map(f -> f.method_40239().map(h -> new class_1799((class_1935)this.asItem.apply(h.comp_349()))).findFirst().orElse(this.empty())).orElse(this.empty());
            any.method_7977((class_2561)ServerScreenHelper.coloredGuiText(String.format("#%s", tag.comp_327()), class_124.field_1065));
            return any;
        })).toList();
    }

    public List<String> asString() {
        return this.list.stream().map(this::valueAsString).toList();
    }

    public int size() {
        return this.list.size();
    }

    private class_1799 empty() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8600);
        ServerScreenHelper.addLore(stack, (class_2561)ServerScreenHelper.coloredGuiText("flan.allowListEmptyTag", class_124.field_1079));
        return stack;
    }

    public void addAllowedItem(Either<T, class_6862<T>> allowed) {
        if (this.mapping.put(this.valueAsString(allowed), this.list.size()) == null) {
            this.list.add(allowed);
            this.claim.setDirty(true);
        }
    }

    public void removeAllowedItem(String value) {
        int idx = this.mapping.getOrDefault(value, 0);
        this.removeAllowedItem(idx);
    }

    public void removeAllowedItem(int index) {
        if (index >= 0 && index < this.list.size()) {
            Either<T, class_6862<T>> val = this.list.remove(index);
            this.mapping.remove(this.valueAsString(val));
            this.claim.setDirty(true);
        }
    }

    public boolean matches(Predicate<T> first, Predicate<class_6862<T>> second) {
        return this.list.stream().anyMatch(e -> (Boolean)e.map(first::test, second::test));
    }

    private String valueAsString(Either<T, class_6862<T>> val) {
        return (String)val.map(i -> this.registry.method_10221(i).toString(), tag -> "#" + String.valueOf(tag.comp_327()));
    }

    public JsonElement save() {
        JsonArray array = new JsonArray();
        this.list.forEach(e -> array.add(this.valueAsString((Either<T, class_6862<T>>)e)));
        return array;
    }

    public void read(JsonArray array) {
        this.list.clear();
        array.forEach(e -> {
            String element = e.getAsString();
            if (element.startsWith("#")) {
                this.addAllowedItem(Either.right((Object)class_6862.method_40092((class_5321)this.registry.method_30517(), (class_2960)new class_2960(element.substring(1)))));
            } else {
                class_2960 id = new class_2960(element);
                if (this.registry.method_10250(id)) {
                    this.addAllowedItem(Either.left((Object)this.registry.method_10223(id)));
                } else {
                    Flan.LOGGER.error("No such registry item for " + String.valueOf(this.registry.method_30517()) + " with id: " + String.valueOf(id));
                }
            }
        });
    }
}

