/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.linguabib.api.LanguageAPI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CommandHelp {
    public static int helpMessage(CommandContext<class_2168> context, Collection<CommandNode<class_2168>> nodes) {
        int page = IntegerArgumentType.getInteger(context, (String)"page");
        return CommandHelp.helpMessage(context, page, nodes);
    }

    public static int helpMessage(CommandContext<class_2168> context, int page, Collection<CommandNode<class_2168>> nodes) {
        List<String> subCommands = CommandHelp.registeredCommands(context, nodes);
        subCommands.remove("?");
        int max = subCommands.size() / 8;
        if (page > max) {
            page = max;
        }
        List<String> header = CommandHelp.lang(context, "flan.commands.helpHeader");
        for (String headerTxt : header) {
            ((class_2168)context.getSource()).method_9226((class_2561)ClaimUtils.translatedText(headerTxt, page, class_124.field_1060), false);
        }
        for (int i = 8 * page; i < 8 * (page + 1); ++i) {
            if (i >= subCommands.size()) continue;
            class_5250 cmdText = ClaimUtils.translatedText("flan.commands.helpCmdEntry", subCommands.get(i), class_124.field_1080);
            ((class_2168)context.getSource()).method_9226((class_2561)cmdText.method_27696(cmdText.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, "/flan help cmd " + subCommands.get(i)))), false);
        }
        class_5250 pageText = null;
        if (page > 0) {
            class_5250 pageTextBack = ClaimUtils.translatedText("flan.commands.help.previous", class_124.field_1077);
            pageTextBack.method_27696(pageTextBack.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, "/flan help " + (page - 1))));
            pageText = pageTextBack;
        }
        if (page < max) {
            class_5250 pageTextNext = ClaimUtils.translatedText("flan.commands.help.next", class_124.field_1077);
            pageTextNext.method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/flan help " + (page + 1))));
            pageText = pageText != null ? pageText.method_10852((class_2561)new class_2585(" | ").method_27692(class_124.field_1063)).method_10852((class_2561)pageTextNext) : pageTextNext;
        }
        if (pageText != null) {
            ((class_2168)context.getSource()).method_9226(pageText, false);
        }
        return 1;
    }

    public static int helpCmd(CommandContext<class_2168> context) {
        String command = StringArgumentType.getString(context, (String)"command");
        return CommandHelp.helpCmd(context, command);
    }

    public static int helpCmd(CommandContext<class_2168> context, String command) {
        List<String> cmdHelp = CommandHelp.lang(context, "flan.command." + command);
        List<String> header = CommandHelp.lang(context, "flan.commands.syntaxHeader");
        for (int i = 0; i < cmdHelp.size(); ++i) {
            if (i == 0) {
                for (String headerTxt : header) {
                    ((class_2168)context.getSource()).method_9226((class_2561)ClaimUtils.translatedText(headerTxt, ClaimUtils.translatedText(cmdHelp.get(i), new Object[0]), class_124.field_1060), false);
                }
                continue;
            }
            ((class_2168)context.getSource()).method_9226((class_2561)ClaimUtils.translatedText(cmdHelp.get(i), class_124.field_1065), false);
        }
        if (command.equals("help")) {
            ((class_2168)context.getSource()).method_9226((class_2561)ClaimUtils.translatedText("flan.wiki", class_124.field_1065), false);
            class_5250 wiki = ClaimUtils.translatedText("https://github.com/Flemmli97/Flan/wiki", class_124.field_1060);
            wiki.method_10862(wiki.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Flemmli97/Flan/wiki")));
            ((class_2168)context.getSource()).method_9226((class_2561)wiki, false);
        }
        return 1;
    }

    public static List<String> registeredCommands(CommandContext<class_2168> context, Collection<CommandNode<class_2168>> nodes) {
        return nodes.stream().filter(node -> node.canUse((Object)((class_2168)context.getSource()))).map(CommandNode::getName).collect(Collectors.toList());
    }

    private static List<String> lang(CommandContext<class_2168> context, String key) {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            return LanguageAPI.getFormattedKeys((class_3222)player, (String)key);
        }
        return LanguageAPI.getFormattedKeys((String)LanguageAPI.defaultServerLanguage(), (String)key);
    }
}

