/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.config.BuySellHandler;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2073;

public class ConfigUpdater {
    private static final Map<Integer, Updater> UPDATER = Config.createHashMap(map -> {
        map.put(6, new Updater(){

            @Override
            public JsonObject configUpdater(JsonObject oldVals) {
                return oldVals;
            }

            @Override
            public void postUpdater(Config config) {
                config.globalDefaultPerms.computeIfPresent("*", (k, v) -> {
                    v.put(BuiltinPermission.ALLOW_FLIGHT, Config.GlobalType.ALLTRUE);
                    v.put(BuiltinPermission.MAY_FLIGHT, Config.GlobalType.ALLFALSE);
                    return v;
                });
            }
        });
        map.put(5, config -> {
            Flan.debug("Updating config to version 5", new Object[0]);
            JsonObject buySellHandler = ConfigHandler.fromJson(config, "buySellHandler");
            JsonArray buyItems = ConfigHandler.arryFromJson(buySellHandler, "buyIngredients");
            ArrayList toRemove = new ArrayList();
            buyItems.forEach(k -> {
                JsonObject o = k.getAsJsonObject();
                if (o.has("ingredient")) {
                    try {
                        class_1856 ingredient = class_1856.method_8102((JsonElement)o.get("ingredient"));
                        class_2073 pred = class_2073.class_2074.method_8973().method_8977((class_1935[])Arrays.stream(ingredient.method_8105()).map(class_1799::method_7909).toArray(class_1935[]::new)).method_8976();
                        o.add("predicate", pred.method_8971());
                        o.remove("ingredient");
                    }
                    catch (JsonParseException jsonParseException) {
                        // empty catch block
                    }
                }
                if (!o.has("predicate") || !o.has("amount")) {
                    Flan.error("Unable to update buy handler ", o);
                    toRemove.add(k);
                }
            });
            toRemove.forEach(arg_0 -> ((JsonArray)buyItems).remove(arg_0));
            buySellHandler.add("buyItems", (JsonElement)buyItems);
            if (buySellHandler.has("ingredient") || buySellHandler.has("sellIngredient")) {
                try {
                    class_1856 legacy = buySellHandler.has("ingredient") ? class_1856.method_8102((JsonElement)buySellHandler.get("ingredient")) : class_1856.field_9017;
                    class_1856 class_18562 = legacy = buySellHandler.has("sellIngredient") ? class_1856.method_8102((JsonElement)buySellHandler.get("sellIngredient")) : legacy;
                    if (!legacy.method_8103() && !legacy.method_8105()[0].method_7960()) {
                        buySellHandler.add("sellItems", (JsonElement)BuySellHandler.ITEM_STACK_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)legacy.method_8105()[0]).result().map(e -> {
                            JsonArray arr = new JsonArray();
                            JsonObject val = new JsonObject();
                            val.add("amount", buySellHandler.get("sellValue"));
                            val.add("item", e);
                            arr.add((JsonElement)val);
                            return arr;
                        }).orElse(new JsonArray()));
                    } else {
                        buySellHandler.add("sellItems", (JsonElement)new JsonArray());
                    }
                }
                catch (JsonSyntaxException e2) {
                    buySellHandler.add("sellItems", (JsonElement)new JsonArray());
                }
            }
            return config;
        });
    });

    public static JsonObject updateConfig(int preVersion, JsonObject config) {
        for (Map.Entry<Integer, Updater> updater : UPDATER.entrySet()) {
            if (updater.getKey() <= preVersion) continue;
            config = updater.getValue().configUpdater(config);
        }
        return config;
    }

    public static void postUpdateConfig(int preVersion, Config config) {
        for (Map.Entry<Integer, Updater> updater : UPDATER.entrySet()) {
            if (updater.getKey() <= preVersion) continue;
            updater.getValue().postUpdater(config);
        }
    }

    static interface Updater {
        public JsonObject configUpdater(JsonObject var1);

        default public void postUpdater(Config config) {
        }
    }
}

