/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.mixin.IHungerAccessor;
import io.github.flemmli97.flan.mixin.IPersistentProjectileVars;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.utils.IOwnedItem;
import io.github.flemmli97.flan.utils.TeleportUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1473;
import net.minecraft.class_1528;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1560;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1681;
import net.minecraft.class_1684;
import net.minecraft.class_1686;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1693;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2649;
import net.minecraft.class_2680;
import net.minecraft.class_2696;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_3988;
import net.minecraft.class_6025;

public class EntityInteractEvents {
    private static final class_2960 TATERZEN = new class_2960("taterzen", "npc");

    public static class_1269 attackEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        return EntityInteractEvents.attackSimple(player, entity, true);
    }

    public static class_1269 useAtEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        class_2338 pos;
        class_3222 serverPlayer;
        block10: {
            block9: {
                if (!(player instanceof class_3222)) break block9;
                serverPlayer = (class_3222)player;
                if (!player.method_7325() && !EntityInteractEvents.canInteract(entity)) break block10;
            }
            return class_1269.field_5811;
        }
        if (entity instanceof class_1569) {
            return class_1269.field_5811;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)world);
        IPermissionContainer claim = storage.getForPermissionCheck(pos = entity.method_24515());
        if (claim != null) {
            Claim real;
            if (claim instanceof Claim && (real = (Claim)claim).canInteractWithEntity(entity)) {
                return class_1269.field_5811;
            }
            class_2960 perm = InteractionOverrideManager.INSTANCE.getEntityInteract(entity.method_5864());
            if (perm != null) {
                return claim.canInteract(serverPlayer, perm, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_1531 && !claim.canInteract(serverPlayer, BuiltinPermission.ARMORSTAND, pos, true)) {
                return class_1269.field_5814;
            }
            if (entity instanceof class_1308) {
                return claim.canInteract(serverPlayer, BuiltinPermission.ANIMALINTERACT, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
            }
        }
        return class_1269.field_5811;
    }

    public static class_1269 useEntity(class_1657 p, class_1937 world, class_1268 hand, class_1297 entity) {
        class_2338 pos;
        class_3222 player;
        block14: {
            block13: {
                if (!(p instanceof class_3222)) break block13;
                player = (class_3222)p;
                if (!p.method_7325() && !EntityInteractEvents.canInteract(entity)) break block14;
            }
            return class_1269.field_5811;
        }
        if (entity instanceof class_1569) {
            return class_1269.field_5811;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)world);
        IPermissionContainer claim = storage.getForPermissionCheck(pos = entity.method_24515());
        if (claim != null) {
            class_6025 tame;
            Claim real;
            if (claim instanceof Claim && (real = (Claim)claim).canInteractWithEntity(entity)) {
                return class_1269.field_5811;
            }
            class_2960 perm = InteractionOverrideManager.INSTANCE.getEntityInteract(entity.method_5864());
            if (perm != null) {
                return claim.canInteract(player, perm, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_1690) {
                return claim.canInteract(player, BuiltinPermission.BOAT, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_1688) {
                if (entity instanceof class_1693) {
                    return claim.canInteract(player, BuiltinPermission.OPENCONTAINER, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
                }
                return claim.canInteract(player, BuiltinPermission.MINECART, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_3988 || class_2378.field_11145.method_10221((Object)entity.method_5864()).equals((Object)TATERZEN)) {
                return claim.canInteract(player, BuiltinPermission.TRADING, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_1533) {
                return claim.canInteract(player, BuiltinPermission.ITEMFRAMEROTATE, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_6025 && (tame = (class_6025)entity).method_6139() != null && tame.method_6139().equals(player.method_5667())) {
                return class_1269.field_5811;
            }
            return claim.canInteract(player, BuiltinPermission.ANIMALINTERACT, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canInteract(class_1297 entity) {
        class_2960 id = class_2378.field_11145.method_10221((Object)entity.method_5864());
        if (ConfigHandler.CONFIG.ignoredEntityTypes.contains(id.method_12836())) return true;
        if (ConfigHandler.CONFIG.ignoredEntityTypes.contains(id.toString())) return true;
        if (!entity.method_5752().stream().anyMatch(ConfigHandler.CONFIG.entityTagIgnore::contains)) return false;
        return true;
    }

    public static boolean projectileHit(class_1676 proj, class_239 res) {
        if (proj.field_6002.field_9236) {
            return false;
        }
        class_1297 owner = proj.method_24921();
        if (owner instanceof class_3222) {
            class_3222 player = (class_3222)owner;
            if (res.method_17783() == class_239.class_240.field_1332) {
                boolean flag;
                class_3965 blockRes = (class_3965)res;
                class_2338 pos = blockRes.method_17777();
                class_2680 state = proj.field_6002.method_8320(pos);
                class_2960 perm = proj instanceof class_1684 ? BuiltinPermission.ENDERPEARL : (proj instanceof class_1681 || proj instanceof class_1686 ? BuiltinPermission.PROJECTILES : InteractionOverrideManager.INSTANCE.getBlockInteract(state.method_26204()));
                if (perm != BuiltinPermission.ENDERPEARL && perm != BuiltinPermission.TARGETBLOCK && perm != BuiltinPermission.PROJECTILES) {
                    return false;
                }
                ClaimStorage storage = ClaimStorage.get((class_3218)proj.field_6002);
                IPermissionContainer claim = storage.getForPermissionCheck(pos);
                if (claim == null) {
                    return false;
                }
                boolean bl = flag = !claim.canInteract(player, perm, pos, true);
                if (flag) {
                    if (proj instanceof class_1665) {
                        class_1665 pers = (class_1665)proj;
                        ((IPersistentProjectileVars)pers).setInBlockState(pers.field_6002.method_8320(pos));
                        class_243 vec3d = blockRes.method_17784().method_1023(pers.method_23317(), pers.method_23318(), pers.method_23321());
                        pers.method_18799(vec3d);
                        class_243 vec3d2 = vec3d.method_1029().method_1021((double)0.05f);
                        pers.method_23327(pers.method_23317() - vec3d2.field_1352, pers.method_23318() - vec3d2.field_1351, pers.method_23321() - vec3d2.field_1350);
                        pers.method_5783(((IPersistentProjectileVars)pers).getSoundEvent(), 1.0f, 1.2f / (pers.field_6002.field_9229.nextFloat() * 0.2f + 0.9f));
                        ((IPersistentProjectileVars)pers).setInGround(true);
                        pers.field_7574 = 7;
                        pers.method_7439(false);
                        pers.method_7451((byte)0);
                        pers.method_7444(class_3417.field_15151);
                        pers.method_7442(false);
                        ((IPersistentProjectileVars)pers).resetPiercingStatus();
                    }
                    if (proj instanceof class_1684) {
                        proj.method_5650(class_1297.class_5529.field_26998);
                    }
                }
                return flag;
            }
            if (res.method_17783() == class_239.class_240.field_1331) {
                boolean fail;
                if (proj instanceof class_1684) {
                    ClaimStorage storage = ClaimStorage.get((class_3218)proj.field_6002);
                    IPermissionContainer claim = storage.getForPermissionCheck(proj.method_24515());
                    return claim.canInteract(player, BuiltinPermission.ENDERPEARL, proj.method_24515(), true);
                }
                class_1297 hit = ((class_3966)res).method_17782();
                boolean bl = fail = EntityInteractEvents.attackSimple((class_1657)player, hit, true) != class_1269.field_5811;
                if (fail && proj instanceof class_1665) {
                    class_1665 pers = (class_1665)proj;
                    if (((class_1665)proj).method_7447() > 0) {
                        IntOpenHashSet pierced = ((IPersistentProjectileVars)pers).getPiercedEntities();
                        if (pierced == null) {
                            pierced = new IntOpenHashSet(5);
                        }
                        pierced.add(hit.method_5628());
                        ((IPersistentProjectileVars)pers).setPiercedEntities(pierced);
                        pers.method_7451((byte)(pers.method_7447() + 1));
                    }
                }
                return fail;
            }
        }
        return false;
    }

    public static boolean preventDamage(class_1297 entity, class_1282 source) {
        if (source.method_5529() instanceof class_3222) {
            return EntityInteractEvents.attackSimple((class_1657)((class_3222)source.method_5529()), entity, true) != class_1269.field_5811;
        }
        if (source.method_5535() && !entity.field_6002.field_9236 && !(entity instanceof class_3222) && !(entity instanceof class_1569)) {
            IPermissionContainer claim = ClaimStorage.get((class_3218)entity.field_6002).getForPermissionCheck(entity.method_24515());
            return claim != null && !claim.canInteract(null, BuiltinPermission.EXPLOSIONS, entity.method_24515());
        }
        return false;
    }

    public static class_1269 attackSimple(class_1657 p, class_1297 entity, boolean message) {
        class_2338 pos;
        class_3222 player;
        block11: {
            block10: {
                if (!(p instanceof class_3222)) break block10;
                player = (class_3222)p;
                if (!p.method_7325() && !EntityInteractEvents.canInteract(entity)) break block11;
            }
            return class_1269.field_5811;
        }
        if (entity instanceof class_1569) {
            return class_1269.field_5811;
        }
        ClaimStorage storage = ClaimStorage.get(player.method_14220());
        IPermissionContainer claim = storage.getForPermissionCheck(pos = entity.method_24515());
        if (claim != null) {
            Claim real;
            if (claim instanceof Claim && (real = (Claim)claim).canAttackEntity(entity)) {
                return class_1269.field_5811;
            }
            if (entity.method_16914() && !claim.canInteract(player, BuiltinPermission.HURTNAMED, pos, message)) {
                return class_1269.field_5814;
            }
            class_2960 perm = InteractionOverrideManager.INSTANCE.getEntityAttack(entity.method_5864());
            if (perm != null) {
                return claim.canInteract(player, perm, pos, message) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_1531 || !(entity instanceof class_1309)) {
                return claim.canInteract(player, BuiltinPermission.BREAKNONLIVING, pos, message) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_1657) {
                return claim.canInteract(player, BuiltinPermission.HURTPLAYER, pos, message) ? class_1269.field_5811 : class_1269.field_5814;
            }
            return claim.canInteract(player, BuiltinPermission.HURTANIMAL, pos, message) ? class_1269.field_5811 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static boolean xpAbsorb(class_1657 player) {
        class_2338 pos;
        ClaimStorage storage;
        IPermissionContainer claim;
        if (player instanceof class_3222 && (claim = (storage = ClaimStorage.get((class_3218)player.field_6002)).getForPermissionCheck(pos = player.method_24515())) != null) {
            return !claim.canInteract((class_3222)player, BuiltinPermission.XP, pos, false);
        }
        return false;
    }

    public static boolean canCollideWith(class_1657 player, class_1297 entity) {
        if (player instanceof class_3222) {
            class_3222 sPlayer = (class_3222)player;
            if (entity instanceof class_1542) {
                class_2338 pos;
                IOwnedItem ownedItem = (IOwnedItem)entity;
                if (ownedItem.getDeathPlayer() != null) {
                    class_3222 other = sPlayer.method_5682().method_3760().method_14602(ownedItem.getDeathPlayer());
                    if (other == null) {
                        return false;
                    }
                    return ownedItem.getDeathPlayer().equals(player.method_5667()) || PlayerClaimData.get(other).deathItemsUnlocked();
                }
                if (sPlayer.method_5667().equals(ownedItem.getPlayerOrigin())) {
                    return true;
                }
                ClaimStorage storage = ClaimStorage.get(sPlayer.method_14220());
                IPermissionContainer claim = storage.getForPermissionCheck(pos = sPlayer.method_24515());
                if (claim != null) {
                    return claim.canInteract(sPlayer, BuiltinPermission.PICKUP, pos, false);
                }
            }
        }
        return true;
    }

    public static boolean canDropItem(class_1657 player, class_1799 stack) {
        if (!player.method_29504() && player instanceof class_3222) {
            ClaimStorage storage = ClaimStorage.get((class_3218)player.field_6002);
            class_2338 pos = player.method_24515();
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            boolean allow = true;
            if (claim != null) {
                allow = claim.canInteract((class_3222)player, BuiltinPermission.DROP, pos, false);
            }
            if (!allow) {
                player.method_31548().method_7394(stack);
                class_2371 stacks = class_2371.method_10211();
                for (int j = 0; j < player.field_7512.field_7761.size(); ++j) {
                    class_1799 itemStack2 = ((class_1735)player.field_7512.field_7761.get(j)).method_7677();
                    stacks.add((Object)(itemStack2.method_7960() ? class_1799.field_8037 : itemStack2));
                }
                ((class_3222)player).field_13987.method_14364((class_2596)new class_2649(player.field_7512.field_7763, 0, stacks, player.field_7498.method_34255()));
            }
            return allow;
        }
        return true;
    }

    public static boolean witherCanDestroy(class_1528 wither) {
        if (wither.field_6002.field_9236) {
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)wither.field_6002);
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                pos.method_25504((class_2382)wither.method_24515(), x, 3, z);
                IPermissionContainer claim = storage.getForPermissionCheck((class_2338)pos);
                if (claim.canInteract(null, BuiltinPermission.WITHER, (class_2338)pos, false)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canEndermanInteract(class_1560 enderman, class_2338 pos) {
        if (enderman.field_6002.field_9236) {
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)enderman.field_6002);
        IPermissionContainer claim = storage.getForPermissionCheck(pos);
        return claim.canInteract(null, BuiltinPermission.ENDERMAN, pos, false);
    }

    public static boolean canSnowGolemInteract(class_1473 snowgolem) {
        if (snowgolem.field_6002.field_9236) {
            return true;
        }
        for (int l = 0; l < 4; ++l) {
            int x = class_3532.method_15357((double)(snowgolem.method_23317() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
            int y = class_3532.method_15357((double)snowgolem.method_23318());
            int z = class_3532.method_15357((double)(snowgolem.method_23321() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
            class_2338 pos = new class_2338(x, y, z);
            IPermissionContainer claim = ClaimStorage.get((class_3218)snowgolem.field_6002).getForPermissionCheck(pos);
            if (claim.canInteract(null, BuiltinPermission.SNOWGOLEM, pos, false)) continue;
            return false;
        }
        return true;
    }

    public static void updateDroppedItem(class_1657 player, class_1542 entity) {
        ((IOwnedItem)entity).setOriginPlayer(player);
    }

    public static Claim currentClaimTick(class_3222 player, Claim currentClaim) {
        class_243 pos = player.method_19538();
        class_2338 rounded = TeleportUtils.roundedBlockPos(pos.method_1031(0.0, (double)player.method_18394(player.method_18376(), player.method_18377(player.method_18376())), 0.0));
        ClaimStorage storage = ClaimStorage.get(player.method_14220());
        Claim newClaim = currentClaim;
        if (currentClaim != null) {
            if (!currentClaim.intersects(player.method_5829())) {
                Claim claim2;
                boolean isSub = currentClaim.parentClaim() != null;
                Claim claim3 = claim2 = isSub ? storage.getClaimAt(rounded) : currentClaim.parentClaim();
                if (claim2 == null) {
                    currentClaim.displayLeaveTitle(player);
                    if (!EntityInteractEvents.gameModeCanFly(player.field_13974.method_14257())) {
                        CrossPlatformStuff.INSTANCE.toggleCreativeFlight(player, false);
                    }
                } else {
                    Claim sub = claim2.getSubClaim(rounded);
                    boolean display = true;
                    if (sub != null) {
                        claim2 = sub;
                    } else {
                        boolean bl = display = currentClaim.enterTitle != null;
                        if (claim2.enterTitle == null) {
                            currentClaim.displayLeaveTitle(player);
                        }
                    }
                    if (display) {
                        claim2.displayEnterTitle(player);
                    }
                }
                newClaim = claim2;
            } else {
                Claim sub;
                if (currentClaim.parentClaim() == null && (sub = currentClaim.getSubClaim(rounded)) != null) {
                    currentClaim = sub;
                    currentClaim.displayEnterTitle(player);
                    newClaim = currentClaim;
                }
                if (!player.method_7325()) {
                    class_2338.class_2339 bPos = rounded.method_25503();
                    boolean isSub = currentClaim.parentClaim() != null;
                    Claim mainClaim = isSub ? currentClaim.parentClaim() : currentClaim;
                    class_1297 passenger = player.method_5854();
                    if (!mainClaim.canInteract(player, BuiltinPermission.CANSTAY, (class_2338)bPos, true) || passenger instanceof class_1690 && !mainClaim.canInteract(player, BuiltinPermission.BOAT, (class_2338)bPos, true)) {
                        Claim sub2 = isSub ? currentClaim : null;
                        class_243 tp = TeleportUtils.getTeleportPos(player, pos, storage, new TeleportUtils.Area2D(sub2 != null ? sub2.getDimensions() : mainClaim.getDimensions()), true, bPos, (claim, nPos) -> claim.canInteract(player, BuiltinPermission.CANSTAY, (class_2338)nPos, false));
                        if (passenger != null) {
                            player.method_5848();
                            passenger.method_20620(tp.method_10216(), tp.method_10214(), tp.method_10215());
                        }
                        player.method_20620(tp.method_10216(), tp.method_10214(), tp.method_10215());
                    }
                    if (player.method_31549().field_7479 && !EntityInteractEvents.gameModeCanFly(player.field_13974.method_14257()) && !mainClaim.canInteract(player, BuiltinPermission.ALLOW_FLIGHT, rounded, true)) {
                        player.method_31549().field_7479 = false;
                        player.field_13987.method_14364((class_2596)new class_2696(player.method_31549()));
                    } else if (!EntityInteractEvents.gameModeCanFly(player.field_13974.method_14257())) {
                        CrossPlatformStuff.INSTANCE.toggleCreativeFlight(player, currentClaim.canInteract(player, BuiltinPermission.MAY_FLIGHT, rounded, false));
                    }
                    if (player.method_7344().method_7589() < 2.0f && mainClaim.canInteract(player, BuiltinPermission.NOHUNGER, (class_2338)bPos, false)) {
                        ((IHungerAccessor)player.method_7344()).setSaturation(2.0f);
                    }
                    currentClaim.applyEffects(player);
                }
            }
        } else if (player.field_6012 % 3 == 0) {
            Claim sub;
            Claim claim4 = storage.getClaimAt(rounded);
            Claim claim5 = sub = claim4 != null ? claim4.getSubClaim(rounded) : null;
            if (sub != null) {
                claim4 = sub;
            }
            if (claim4 != null) {
                claim4.displayEnterTitle(player);
            }
            newClaim = claim4;
        }
        return newClaim;
    }

    protected static boolean gameModeCanFly(class_1934 gameType) {
        return gameType == class_1934.field_9220 || gameType == class_1934.field_9219;
    }

    public static boolean canFrostwalkerFreeze(class_3218 world, class_2338 pos, class_1309 entity) {
        if (entity instanceof class_3222) {
            IPermissionContainer claim = ClaimStorage.get(world).getForPermissionCheck(pos);
            return claim.canInteract((class_3222)entity, BuiltinPermission.FROSTWALKER, pos, false);
        }
        return true;
    }

    public static boolean preventLightningConvert(class_1297 entity) {
        if (entity.field_6002.field_9236 || entity instanceof class_1569) {
            return false;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)entity.field_6002);
        IPermissionContainer claim = storage.getForPermissionCheck(entity.method_24515());
        return !claim.canInteract(null, BuiltinPermission.LIGHTNING, entity.method_24515(), false);
    }
}

