/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.fabric;

import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.fabric.ItemUseBlockFlags;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.event.BlockInteractEvents;
import io.github.flemmli97.flan.event.EntityInteractEvents;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.event.PlayerEvents;
import io.github.flemmli97.flan.event.WorldEvents;
import io.github.flemmli97.flan.fabric.integration.HarvestWithEase;
import io.github.flemmli97.flan.fabric.platform.integration.claiming.FlanProtectionProvider;
import io.github.flemmli97.flan.fabric.platform.integration.playerability.PlayerAbilityEvents;
import io.github.flemmli97.flan.platform.integration.webmap.BluemapIntegration;
import io.github.flemmli97.flan.platform.integration.webmap.DynmapIntegration;
import io.github.flemmli97.flan.player.PlayerDataHandler;
import io.github.flemmli97.flan.scoreboard.ClaimCriterias;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;

public class FlanFabric
implements ModInitializer {
    public static final class_2960 EVENT_PHASE = new class_2960("flan", "events");

    public void onInitialize() {
        PlayerBlockBreakEvents.BEFORE.register(BlockInteractEvents::breakBlocks);
        AttackBlockCallback.EVENT.register(BlockInteractEvents::startBreakBlocks);
        UseBlockCallback.EVENT.addPhaseOrdering(EVENT_PHASE, Event.DEFAULT_PHASE);
        UseBlockCallback.EVENT.register(EVENT_PHASE, FlanFabric::useBlocks);
        UseEntityCallback.EVENT.register(EntityInteractEvents::useAtEntity);
        AttackEntityCallback.EVENT.register(EntityInteractEvents::attackEntity);
        UseItemCallback.EVENT.register(ItemInteractEvents::useItem);
        ServerLifecycleEvents.SERVER_STARTING.register(FlanFabric::serverLoad);
        ServerLifecycleEvents.SERVER_STARTED.register(FlanFabric::serverFinishLoad);
        ServerTickEvents.START_SERVER_TICK.register(WorldEvents::serverTick);
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> PlayerEvents.onLogout((class_1657)handler.field_14140));
        CommandRegistrationCallback.EVENT.register(CommandClaim::register);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new IdentifiableResourceReloadListener(){

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return PermissionManager.INSTANCE.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }

            public class_2960 getFabricId() {
                return new class_2960("flan", "permissions");
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new IdentifiableResourceReloadListener(){

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return InteractionOverrideManager.INSTANCE.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }

            public class_2960 getFabricId() {
                return new class_2960("flan", "interaction_overrides");
            }
        });
        Flan.permissionAPI = FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0");
        Flan.gunpowder = FabricLoader.getInstance().isModLoaded("gunpowder-currency");
        Flan.playerAbilityLib = FabricLoader.getInstance().isModLoaded("playerabilitylib");
        Flan.ftbRanks = FabricLoader.getInstance().isModLoaded("ftbranks");
        Flan.octoEconomy = FabricLoader.getInstance().isModLoaded("octo-economy-api");
        Flan.diamondCurrency = FabricLoader.getInstance().isModLoaded("diamondeconomy");
        Flan.ftbChunks = FabricLoader.getInstance().isModLoaded("ftbchunks");
        Flan.gomlServer = FabricLoader.getInstance().isModLoaded("goml");
        Flan.commonProtApi = FabricLoader.getInstance().isModLoaded("common-protection-api");
        Flan.impactor = FabricLoader.getInstance().isModLoaded("impactor");
        Flan.create = FabricLoader.getInstance().isModLoaded("create");
        if (Flan.playerAbilityLib) {
            PlayerAbilityEvents.register();
        }
        if (FabricLoader.getInstance().isModLoaded("dynmap")) {
            DynmapIntegration.reg();
        }
        if (FabricLoader.getInstance().isModLoaded("harvestwithease")) {
            HarvestWithEase.init();
        }
        if (Flan.commonProtApi) {
            FlanProtectionProvider.register();
        }
        ClaimCriterias.init();
    }

    public static void serverLoad(MinecraftServer server) {
        ConfigHandler.reloadConfigs();
        if (FabricLoader.getInstance().isModLoaded("bluemap")) {
            BluemapIntegration.reg(server);
        }
    }

    public static void serverFinishLoad(MinecraftServer server) {
        PlayerDataHandler.deleteInactivePlayerData(server);
    }

    public static class_1269 useBlocks(class_1657 p, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (p instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)p;
            ItemUseBlockFlags flags = ItemUseBlockFlags.fromPlayer(serverPlayer);
            class_1269 res = BlockInteractEvents.useBlocks(p, world, hand, hitResult);
            if (res == class_1269.field_5812) {
                return res;
            }
            flags.stopCanUseBlocks(res == class_1269.field_5814);
            flags.stopCanUseItems(ItemInteractEvents.onItemUseBlock(new class_1838(p, hand, hitResult)) == class_1269.field_5814);
            if (!flags.allowUseBlocks() && !flags.allowUseItems()) {
                return class_1269.field_5814;
            }
        }
        return class_1269.field_5811;
    }
}

