/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.fabric.platform.integration.currency;

import com.epherical.octoecon.OctoEconomy;
import com.epherical.octoecon.api.Currency;
import com.epherical.octoecon.api.user.UniqueUser;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.platform.integration.currency.CommandCurrency;
import io.github.flemmli97.flan.platform.integration.currency.CommonCurrency;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.gunpowder.entities.StoredBalance;
import io.github.gunpowder.modelhandlers.BalanceHandler;
import java.math.BigDecimal;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CommandCurrencyImpl
implements CommandCurrency {
    private static final class_2960 eightyEconomyCurrencyName = new class_2960("eights_economy", "dollars");

    @Override
    public boolean sellClaimBlocks(class_3222 player, int blocks, float value, Consumer<class_2561> message) {
        if (value == -1.0f) {
            message.accept((class_2561)ClaimUtils.translatedText("flan.sellDisabled", class_124.field_1079));
            return false;
        }
        int common = CommonCurrency.sell(player, blocks, value, message);
        if (common != -1) {
            return common == 1;
        }
        if (Flan.gunpowder) {
            PlayerClaimData data = PlayerClaimData.get(player);
            if (data.getAdditionalClaims() - Math.max(0, data.usedClaimBlocks() - data.getClaimBlocks()) < blocks) {
                message.accept((class_2561)ClaimUtils.translatedText("flan.sellFail", class_124.field_1079));
                return false;
            }
            StoredBalance bal = BalanceHandler.INSTANCE.getUser(player.method_5667());
            BigDecimal price = BigDecimal.valueOf((float)blocks * value);
            bal.setBalance(bal.getBalance().add(price));
            BalanceHandler.INSTANCE.updateUser(bal);
            data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
            message.accept((class_2561)ClaimUtils.translatedText("flan.sellSuccess", blocks, price, class_124.field_1065));
            return true;
        }
        if (Flan.octoEconomy) {
            PlayerClaimData data = PlayerClaimData.get(player);
            if (data.getAdditionalClaims() - Math.max(0, data.usedClaimBlocks() - data.getClaimBlocks()) < blocks) {
                message.accept((class_2561)ClaimUtils.translatedText("flan.sellFail", class_124.field_1079));
                return false;
            }
            Currency currency = OctoEconomy.getInstance().getCurrentEconomy().getCurrency(eightyEconomyCurrencyName);
            if (currency == null) {
                message.accept((class_2561)ClaimUtils.translatedText("flan.currencyMissing", class_124.field_1079));
                return false;
            }
            UniqueUser user = OctoEconomy.getInstance().getCurrentEconomy().getOrCreatePlayerAccount(player.method_5667());
            double price = (float)blocks * value;
            user.depositMoney(currency, price, "flan.claimblocks.sell");
            data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
            message.accept((class_2561)ClaimUtils.translatedText("flan.sellSuccess", blocks, price, class_124.field_1065));
        }
        message.accept((class_2561)ClaimUtils.translatedText("flan.currencyMissing", class_124.field_1079));
        return false;
    }

    @Override
    public boolean buyClaimBlocks(class_3222 player, int blocks, float value, Consumer<class_2561> message) {
        if (value == -1.0f) {
            message.accept((class_2561)ClaimUtils.translatedText("flan.buyDisabled", class_124.field_1079));
            return false;
        }
        int common = CommonCurrency.buy(player, blocks, value, message);
        if (common != -1) {
            return common == 1;
        }
        if (Flan.gunpowder) {
            StoredBalance bal = BalanceHandler.INSTANCE.getUser(player.method_5667());
            BigDecimal price = BigDecimal.valueOf(Math.max(0.0f, (float)blocks * value));
            if (bal.getBalance().compareTo(price) >= 0) {
                PlayerClaimData data = PlayerClaimData.get(player);
                data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                bal.setBalance(bal.getBalance().subtract(price));
                BalanceHandler.INSTANCE.updateUser(bal);
                message.accept((class_2561)ClaimUtils.translatedText("flan.buySuccess", blocks, price, class_124.field_1065));
                return true;
            }
            message.accept((class_2561)ClaimUtils.translatedText("flan.buyFail", class_124.field_1079));
            return false;
        }
        if (Flan.octoEconomy) {
            Currency currency = OctoEconomy.getInstance().getCurrentEconomy().getCurrency(eightyEconomyCurrencyName);
            if (currency == null) {
                message.accept((class_2561)ClaimUtils.translatedText("flan.currencyMissing", class_124.field_1079));
                return false;
            }
            UniqueUser user = OctoEconomy.getInstance().getCurrentEconomy().getOrCreatePlayerAccount(player.method_5667());
            double price = Math.max(0.0f, (float)blocks * value);
            if (user.getBalance(currency) >= price) {
                PlayerClaimData data = PlayerClaimData.get(player);
                data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                user.withdrawMoney(currency, price, "flan.claimblocks.buy");
                message.accept((class_2561)ClaimUtils.translatedText("flan.buySuccess", blocks, price, class_124.field_1065));
                return true;
            }
            message.accept((class_2561)ClaimUtils.translatedText("flan.buyFail", class_124.field_1079));
            return false;
        }
        message.accept((class_2561)ClaimUtils.translatedText("flan.currencyMissing", class_124.field_1079));
        return false;
    }
}

