/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.mixin.AbstractContainerAccessor;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3417;

public abstract class PagedServerOnlyScreenHandler<T>
extends ServerOnlyScreenHandler<T> {
    private int page;

    protected PagedServerOnlyScreenHandler(int syncId, class_1661 playerInventory, int rows, T additionalData) {
        super(syncId, playerInventory, rows, additionalData);
    }

    @Override
    protected final void setupGui() {
        class_1799 stack;
        super.setupGui();
        PageSettings settings = this.pageSettings();
        if (this.page >= 1 && settings.previousSlot() != -1) {
            stack = new class_1799((class_1935)class_1802.field_8107);
            stack.method_7977((class_2561)ServerScreenHelper.coloredGuiText("flan.screenPrevious", class_124.field_1068));
            ((class_1735)this.field_7761.get(settings.previousSlot())).method_7673(stack);
        }
        if (this.page < settings.maxPages() && settings.nextSlot() != -1) {
            stack = new class_1799((class_1935)class_1802.field_8107);
            stack.method_7977((class_2561)ServerScreenHelper.coloredGuiText("flan.screenNext", class_124.field_1068));
            ((class_1735)this.field_7761.get(settings.nextSlot())).method_7673(stack);
        }
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return true;
    }

    @Override
    public void method_7593(int i, int j, class_1713 clickType, class_1657 player) {
        if (this.handlePageFlip(i)) {
            for (class_1712 listener : ((AbstractContainerAccessor)((Object)this)).listeners()) {
                listener.method_7635((class_1703)this, i, ((class_1735)this.field_7761.get(i)).method_7677().method_7972());
            }
            return;
        }
        super.method_7593(i, j, clickType, player);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        if (index < 0) {
            return class_1799.field_8037;
        }
        if (this.handlePageFlip(index)) {
            return ((class_1735)this.field_7761.get(index)).method_7677().method_7972();
        }
        return super.method_7601(player, index);
    }

    private boolean handlePageFlip(int slot) {
        boolean next;
        PageSettings settings = this.pageSettings();
        boolean previous = this.page > 0 && settings.previousSlot() != -1 && slot == settings.previousSlot();
        boolean bl = next = this.page < settings.maxPages() && settings.nextSlot() != -1 && slot == settings.nextSlot();
        if (previous || next) {
            if (previous) {
                this.flipPrevious();
            } else {
                this.flipNext();
            }
            return true;
        }
        return false;
    }

    protected abstract PageSettings pageSettings();

    public int getPage() {
        return this.page;
    }

    public void flipNext() {
        this.page = Math.min(this.pageSettings().maxPages(), ++this.page);
        ServerScreenHelper.playSongToPlayer(this.player, class_3417.field_15015, 1.0f, 1.0f);
        this.setupGui();
        this.method_7623();
    }

    public void flipPrevious() {
        this.page = Math.max(0, --this.page);
        ServerScreenHelper.playSongToPlayer(this.player, class_3417.field_15015, 1.0f, 1.0f);
        this.setupGui();
        this.method_7623();
    }

    public record PageSettings(int maxPages, int previousSlot, int nextSlot) {
    }
}

