/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import com.google.common.collect.Lists;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_5250;

public class PotionEditScreenHandler
extends PagedServerOnlyScreenHandler<Claim> {
    private boolean removeMode;

    protected PotionEditScreenHandler(int syncId, class_1661 playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
    }

    public static void openPotionMenu(class_1657 player, final Claim claim) {
        class_3908 fac = new class_3908(){

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new PotionEditScreenHandler(syncId, inv, claim);
            }

            public class_2561 method_5476() {
                return ClaimUtils.translatedText("flan.screenPotions", new Object[0]);
            }
        };
        player.method_17355(fac);
    }

    @Override
    protected void fillInventoryWith() {
        Map<class_1291, Integer> potions = ((Claim)this.data).getPotions();
        ArrayList key = Lists.newArrayList(potions.keySet());
        key.sort(Comparator.comparing(eff -> class_2378.field_11159.method_10221(eff).toString()));
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                class_1799 close = new class_1799((class_1935)class_1802.field_8626);
                close.method_7977((class_2561)ServerScreenHelper.coloredGuiText("flan.screenBack", class_124.field_1079));
                ((class_1735)this.field_7761.get(i)).method_7673(close);
                continue;
            }
            if (i == 3) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8782);
                stack.method_7977((class_2561)ServerScreenHelper.coloredGuiText("flan.screenAdd", class_124.field_1077));
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i == 4) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8793);
                stack.method_7977((class_2561)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), class_124.field_1079));
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((class_1735)this.field_7761.get(i)).method_7673(ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < potions.size()) {
                class_1291 effect = (class_1291)key.get(id);
                class_1799 effectStack = new class_1799((class_1935)class_1802.field_8574);
                class_5250 txt = ClaimUtils.translatedText(effect.method_5567(), new Object[0]);
                Set<class_1293> inst = Collections.singleton(new class_1293(effect, 0, potions.get(effect).intValue()));
                effectStack.method_7948().method_10582("FlanEffect", class_2378.field_11159.method_10221((Object)effect).toString());
                effectStack.method_7969().method_10569("CustomPotionColor", class_1844.method_8055(inst));
                txt.method_10852((class_2561)new class_2585("-" + String.valueOf(potions.get(effect))));
                class_5250 comp = ServerScreenHelper.coloredGuiText("flan.screenPotionText", txt, class_124.field_1058);
                effectStack.method_7977((class_2561)comp);
                ((class_1735)this.field_7761.get(i)).method_7673(effectStack);
                continue;
            }
            ((class_1735)this.field_7761.get(i)).method_7673(class_1799.field_8037);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(class_3222 player, int index, class_1735 slot, int clickType) {
        if (index == 0) {
            player.method_7346();
            player.method_5682().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
            ServerScreenHelper.playSongToPlayer(player, class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.method_7346();
            player.method_5682().execute(() -> StringResultScreenHandler.createNewStringResult((class_1657)player, s -> {
                String[] potion = s.split(";");
                int amp = 1;
                class_1291 effect = (class_1291)class_2378.field_11159.method_10223(new class_2960(potion[0]));
                if (effect == null || effect == class_1294.field_5926 && !potion[0].equals("minecraft:luck")) {
                    ServerScreenHelper.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
                    return;
                }
                if (potion.length > 1) {
                    try {
                        amp = Integer.parseInt(potion[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ((Claim)this.data).addPotion(effect, amp);
                player.method_7346();
                player.method_5682().execute(() -> PotionEditScreenHandler.openPotionMenu((class_1657)player, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_14559, 1.0f, 1.0f);
            }, () -> {
                player.method_7346();
                player.method_5682().execute(() -> PotionEditScreenHandler.openPotionMenu((class_1657)player, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            class_1799 stack = new class_1799((class_1935)class_1802.field_8793);
            stack.method_7977((class_2561)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), class_124.field_1079));
            slot.method_7673(stack);
            ServerScreenHelper.playSongToPlayer(player, class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        class_1799 stack = slot.method_7677();
        if (!stack.method_7960() && this.removeMode) {
            String effect = stack.method_7948().method_10558("FlanEffect");
            ((Claim)this.data).removePotion((class_1291)class_2378.field_11159.method_10223(new class_2960(effect)));
            slot.method_7673(class_1799.field_8037);
            ServerScreenHelper.playSongToPlayer(player, class_3417.field_14911, 1.0f, 1.0f);
        }
        return false;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        return new PagedServerOnlyScreenHandler.PageSettings((((Claim)this.data).getPotions().size() - 1) / 28, 47, 51);
    }
}

