/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class ClientBlockDisplayTracker {
    private final Map<UUID, Set<DisplayData>> fakeBlocks = new HashMap<UUID, Set<DisplayData>>();
    private final Map<class_2338, List<UUID>> lookup = new HashMap<class_2338, List<UUID>>();
    private final class_3222 player;

    public ClientBlockDisplayTracker(class_3222 player) {
        this.player = player;
    }

    public void displayFakeBlocks(UUID id, DisplayData ... blocks) {
        HashSet<DisplayData> newData = new HashSet<DisplayData>(List.of(blocks));
        this.displayFakeBlocks(id, newData);
    }

    public void displayFakeBlocks(UUID id, Set<DisplayData> blocks) {
        Sets.SetView diff;
        Set<DisplayData> current = this.fakeBlocks.get(id);
        if (current != null && !(diff = Sets.difference(current, blocks)).isEmpty()) {
            this.resetBlocks(id, (Set<DisplayData>)diff);
        }
        for (DisplayData data : blocks) {
            this.player.field_13987.method_14364((class_2596)new class_2626(data.pos, data.state));
            this.lookup.computeIfAbsent(data.pos, k -> new ArrayList()).add(id);
        }
        this.fakeBlocks.put(id, blocks);
    }

    public void resetFakeBlocks(UUID id) {
        Set<DisplayData> current = this.fakeBlocks.remove(id);
        if (current != null) {
            this.resetBlocks(id, current);
        }
    }

    private void resetBlocks(UUID id, Set<DisplayData> blocks) {
        blocks.forEach(d -> {
            List<UUID> stateLookup = this.lookup.get(d.pos);
            class_2680 state = null;
            if (stateLookup != null) {
                Set<DisplayData> others;
                stateLookup.removeIf(i -> i.equals(id));
                if (!stateLookup.isEmpty() && (others = this.fakeBlocks.get(stateLookup.get(stateLookup.size() - 1))) != null) {
                    for (DisplayData o : others) {
                        if (!o.pos.equals((Object)d.pos)) continue;
                        state = o.state;
                        break;
                    }
                }
                if (stateLookup.isEmpty()) {
                    this.lookup.remove(d.pos);
                }
            }
            this.player.field_13987.method_14364((class_2596)new class_2626(d.pos, state == null ? this.player.field_6002.method_8320(d.pos) : state));
        });
    }

    public record DisplayData(class_2338 pos, class_2680 state) {
        @Override
        public int hashCode() {
            return this.pos.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DisplayData)) {
                return false;
            }
            DisplayData data = (DisplayData)obj;
            return this.pos.equals((Object)data.pos);
        }
    }
}

