/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api;

import io.github.flemmli97.flan.api.data.IPermissionStorage;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class ClaimHandler {
    public static boolean canInteract(ServerPlayer player, BlockPos pos, ResourceLocation permission) {
        return ClaimHandler.getPermissionStorage(player.serverLevel()).getForPermissionCheck(pos).canInteract(player, permission, pos);
    }

    public static IPermissionStorage getPermissionStorage(ServerLevel level) {
        return ClaimStorage.get(level);
    }

    public static IPlayerData getPlayerData(ServerPlayer player) {
        return PlayerClaimData.get(player);
    }

    public static IPlayerData getPlayerData(MinecraftServer server, UUID uuid) {
        ServerPlayer player = server.getPlayerList().getPlayer(uuid);
        if (player != null) {
            return ClaimHandler.getPlayerData(player);
        }
        return new OfflinePlayerData(server, uuid);
    }

    public static void registerMapping(String key, ResourceLocation newId) {
        BuiltinPermission.registerMapping(key, newId);
    }
}

