/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class ClaimGroupCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"group").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.group"))).then(Commands.literal((String)"add").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).executes(ClaimGroupCommand::addGroup)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::groupSuggestion).executes(ClaimGroupCommand::removeGroup)))).then(((LiteralArgumentBuilder)Commands.literal((String)"players").then(Commands.literal((String)"add").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).suggests(CommandHelpers::groupSuggestion).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(ClaimGroupCommand::addPlayer)).then(Commands.literal((String)"overwrite").executes(ClaimGroupCommand::forceAddPlayer)))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).suggests(CommandHelpers::groupSuggestion).then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).suggests((context, build) -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            String group = StringArgumentType.getString((CommandContext)context, (String)"group");
            List<Object> list = new ArrayList();
            CommandSourceStack src = (CommandSourceStack)context.getSource();
            ClaimStorage storage = ClaimStorage.get(src.getLevel());
            Claim claim = storage.getClaimAt(src.getPlayerOrException().blockPosition());
            if (claim != null && claim.canInteract(src.getPlayerOrException(), BuiltinPermission.EDITPERMS, src.getPlayerOrException().blockPosition())) {
                list = claim.playersFromGroup(player.getServer(), group).stream().map(GameProfile::getName).toList();
            }
            return SharedSuggestionProvider.suggest(list, (SuggestionsBuilder)build);
        }).executes(ClaimGroupCommand::removePlayer))))));
    }

    private static int addGroup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ClaimGroupCommand.modifyGroup(context, false);
    }

    private static int removeGroup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ClaimGroupCommand.modifyGroup(context, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int modifyGroup(CommandContext<CommandSourceStack> context, boolean remove) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String group = StringArgumentType.getString(context, (String)"group");
        Claim claim = CommandClaim.fromContext(context);
        if (claim == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.DARK_RED));
            return 0;
        }
        BlockPos pos = CommandClaim.pos(context);
        if (PlayerClaimData.get((ServerPlayer)player).getClaimMode().isSubclaim && (sub = claim.getSubClaim(pos)) != null) {
            claim = sub;
        }
        if (remove) {
            if (claim.removePermGroup(player, group)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.groupRemove", group, ChatFormatting.GOLD), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED));
            return 0;
        }
        if (claim.groups().contains(group)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.groupExist", group, ChatFormatting.RED));
            return 0;
        }
        if (claim.editPerms(player, group, BuiltinPermission.EDITPERMS, -1)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.groupAdd", group, ChatFormatting.GOLD), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED));
        return 0;
    }

    private static int forceAddPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        return ClaimGroupCommand.modifyPlayer(context, group, true);
    }

    private static int addPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        return ClaimGroupCommand.modifyPlayer(context, group, false);
    }

    private static int removePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ClaimGroupCommand.modifyPlayer(context, null, false);
    }

    private static int modifyPlayer(CommandContext<CommandSourceStack> context, String group, boolean force) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = CommandClaim.fromContext(context);
        if (claim == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.DARK_RED));
            return 0;
        }
        BlockPos pos = CommandClaim.pos(context);
        if (PlayerClaimData.get((ServerPlayer)player).getClaimMode().isSubclaim && (sub = claim.getSubClaim(pos)) != null) {
            claim = sub;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.blockPosition())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED));
            return 0;
        }
        ArrayList<String> modified = new ArrayList<String>();
        for (GameProfile prof : GameProfileArgument.getGameProfiles(context, (String)"players")) {
            if (!claim.setPlayerGroup(prof.getId(), group, force)) continue;
            modified.add(prof.getName());
        }
        if (group == null) {
            if (!modified.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.playerRemove", modified, ChatFormatting.GOLD), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.playerRemoveNo", ChatFormatting.RED));
            }
        } else if (!modified.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.playerModify", group, modified, ChatFormatting.GOLD), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.playerModifyNo", group, ChatFormatting.RED));
        }
        return modified.size();
    }
}

