/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ClaimPermissionCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"permission").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.permission"))).then(Commands.literal((String)"personal").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::personalGroupSuggestion).then(Commands.argument((String)"permission", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<CommandSourceStack>)ctx, b, true)).then(Commands.argument((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(ClaimPermissionCommand::editPersonalPerm)))))).then(Commands.literal((String)"global").then(Commands.argument((String)"permission", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<CommandSourceStack>)ctx, b, false)).then(Commands.argument((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(ClaimPermissionCommand::editGlobalPerm))))).then(Commands.literal((String)"group").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::groupSuggestion).then(Commands.argument((String)"permission", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<CommandSourceStack>)ctx, b, true)).then(Commands.argument((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(ClaimPermissionCommand::editGroupPerm))))));
    }

    private static int editGlobalPerm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        return ClaimPermissionCommand.editPerms(context, null, mode);
    }

    private static int editGroupPerm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        return ClaimPermissionCommand.editPerms(context, StringArgumentType.getString(context, (String)"group"), mode);
    }

    private static int editPerms(CommandContext<CommandSourceStack> context, String group, int mode) throws CommandSyntaxException {
        String setPerm;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = CommandClaim.getClaimFromMode(context, player, BuiltinPermission.EDITPERMS);
        if (claim == null) {
            return 0;
        }
        ResourceLocation perm = ResourceLocationArgument.getId(context, (String)"permission");
        if (group != null && PermissionManager.getInstance().isGlobalPermission(perm)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.nonGlobalOnly", perm, ChatFormatting.DARK_RED));
            return 0;
        }
        if (PermissionManager.getInstance().get(perm) == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noSuchPerm", perm, ChatFormatting.DARK_RED));
            return 0;
        }
        String string = mode == 1 ? "true" : (setPerm = mode == 0 ? "false" : "default");
        if (group == null) {
            claim.editGlobalPerms(player, perm, mode);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.editPerm", perm, setPerm, ChatFormatting.GOLD), false);
        } else {
            claim.editPerms(player, group, perm, mode);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.editPermGroup", perm, group, setPerm, ChatFormatting.GOLD), false);
        }
        return 1;
    }

    private static int editPersonalPerm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String setPerm;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String group = StringArgumentType.getString(context, (String)"group");
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        ResourceLocation perm = ResourceLocationArgument.getId(context, (String)"permission");
        if (PermissionManager.getInstance().isGlobalPermission(perm)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.nonGlobalOnly", perm, ChatFormatting.DARK_RED));
            return 0;
        }
        if (PermissionManager.getInstance().get(perm) == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noSuchPerm", perm, ChatFormatting.DARK_RED));
            return 0;
        }
        String string = mode == 1 ? "true" : (setPerm = mode == 0 ? "false" : "default");
        if (PlayerClaimData.get(player).editDefaultPerms(group, perm, mode)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.editPersonalGroup", group, perm, setPerm, ChatFormatting.GOLD), false);
        }
        return 1;
    }
}

