/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.commands.PendingCommand;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.ClaimMode;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class DeleteClaimCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete"))).executes(DeleteClaimCommand::deleteClaim)).then(((LiteralArgumentBuilder)Commands.literal((String)"deleteAll").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete.all"))).executes(DeleteClaimCommand::deleteAllClaim)).then(((LiteralArgumentBuilder)Commands.literal((String)"deleteSubClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete.sub"))).executes(DeleteClaimCommand::deleteSubClaim)).then(((LiteralArgumentBuilder)Commands.literal((String)"deleteAllSubClaims").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete.sub.all"))).executes(DeleteClaimCommand::deleteAllSubClaim)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"adminDelete").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.delete", true))).executes(DeleteClaimCommand::adminDelete)).then(Commands.literal((String)"all").then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(DeleteClaimCommand::adminDeleteAll))));
    }

    private static int deleteClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ClaimStorage storage = ClaimStorage.get(((CommandSourceStack)context.getSource()).getLevel());
        Claim claim = CommandClaim.fromContext(context);
        boolean check = CommandClaim.check(player, player.blockPosition(), claim, BuiltinPermission.EDITCLAIM, b -> {
            if (b.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.DARK_RED));
            } else if (!((Boolean)b.get()).booleanValue()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.deleteClaimError", ChatFormatting.DARK_RED));
            }
        });
        if (!check) {
            return 0;
        }
        if (!storage.deleteClaim(claim, true, PlayerClaimData.get(player).getClaimMode(), ((CommandSourceStack)context.getSource()).getLevel())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.deleteSubClaimError", ChatFormatting.DARK_RED));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.deleteClaim", ChatFormatting.RED), false);
        return 1;
    }

    private static int deleteAllClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(((CommandSourceStack)context.getSource()).getPlayerOrException());
        data.deferCommand(new PendingCommand(context, () -> {
            for (ServerLevel level : ((CommandSourceStack)context.getSource()).getServer().getAllLevels()) {
                ClaimStorage storage = ClaimStorage.get(level);
                storage.allClaimsFromPlayer(player.getUUID()).forEach(claim -> storage.deleteClaim((Claim)claim, true, data.getClaimMode(), level));
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.deleteAllClaim", ChatFormatting.GOLD), false);
            return 1;
        }));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.confirmCommand", ChatFormatting.GOLD), true);
        return 1;
    }

    private static int deleteSubClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = CommandClaim.fromContext(context);
        if (claim == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.RED));
            return 0;
        }
        Claim sub = claim.getSubClaim(CommandClaim.pos(context));
        if (sub == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noSubClaim", ChatFormatting.RED));
            return 0;
        }
        boolean check = CommandClaim.check(player, player.blockPosition(), claim, BuiltinPermission.EDITCLAIM, b -> {
            if (b.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.DARK_RED));
            } else if (!((Boolean)b.get()).booleanValue()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.deleteClaimError", ChatFormatting.DARK_RED));
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.deleteSubClaim", ChatFormatting.DARK_RED), false);
            }
        });
        if (!check) {
            return 0;
        }
        claim.deleteSubClaim(sub);
        return 1;
    }

    private static int deleteAllSubClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = CommandClaim.fromContext(context);
        boolean check = CommandClaim.check(player, CommandClaim.pos(context), claim, BuiltinPermission.EDITCLAIM, CommandClaim.genericNoPermMessage((CommandSourceStack)context.getSource()));
        if (!check) {
            return 0;
        }
        PlayerClaimData data = PlayerClaimData.get(((CommandSourceStack)context.getSource()).getPlayerOrException());
        data.deferCommand(new PendingCommand(context, () -> {
            List<Claim> subs = claim.getAllSubclaims();
            subs.forEach(claim::deleteSubClaim);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.deleteSubClaimAll", ChatFormatting.DARK_RED), false);
            return 1;
        }));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.confirmCommand", ChatFormatting.GOLD), true);
        return 1;
    }

    private static int adminDelete(CommandContext<CommandSourceStack> context) {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        ClaimStorage storage = ClaimStorage.get(src.getLevel());
        Claim claim = CommandClaim.fromContext(context);
        if (claim == null) {
            src.sendSuccess(() -> ClaimUtils.translatedText("flan.noClaim", ChatFormatting.RED), false);
            return 0;
        }
        storage.deleteClaim(claim, true, ClaimMode.DEFAULT, src.getLevel());
        src.sendSuccess(() -> ClaimUtils.translatedText("flan.deleteClaim", ChatFormatting.RED), true);
        return 1;
    }

    private static int adminDeleteAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(context, (String)"players");
        Entity entity = src.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerClaimData data = PlayerClaimData.get(player);
            data.deferCommand(new PendingCommand(context, () -> {
                ArrayList<String> players = new ArrayList<String>();
                for (GameProfile prof : profiles) {
                    for (ServerLevel level : src.getLevel().getServer().getAllLevels()) {
                        ClaimStorage storage = ClaimStorage.get(level);
                        storage.allClaimsFromPlayer(prof.getId()).forEach(claim -> storage.deleteClaim((Claim)claim, true, ClaimMode.DEFAULT, level));
                    }
                    players.add(prof.getName());
                }
                src.sendSuccess(() -> ClaimUtils.translatedText("flan.adminDeleteAll", players, ChatFormatting.GOLD), true);
                return 1;
            }));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.confirmCommand", ChatFormatting.GOLD), true);
            return 1;
        }
        ArrayList<String> players = new ArrayList<String>();
        for (GameProfile prof : profiles) {
            for (ServerLevel level : src.getLevel().getServer().getAllLevels()) {
                ClaimStorage storage = ClaimStorage.get(level);
                storage.allClaimsFromPlayer(prof.getId()).forEach(claim -> storage.deleteClaim((Claim)claim, true, ClaimMode.DEFAULT, level));
            }
            players.add(prof.getName());
        }
        src.sendSuccess(() -> ClaimUtils.translatedText("flan.adminDeleteAll", players, ChatFormatting.GOLD), true);
        return 1;
    }
}

