/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimBox;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.ClaimMode;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class ExpandCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"expand").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.claim.create"))).then(Commands.argument((String)"distance", (ArgumentType)IntegerArgumentType.integer()).executes(ExpandCommand::expandClaim)));
    }

    private static int expandClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        ClaimMode mode = PlayerClaimData.get(player).getClaimMode();
        int amount = IntegerArgumentType.getInteger(context, (String)"distance");
        Claim claim = ExpandCommand.findClaim((CommandSourceStack)context.getSource(), player, storage, mode);
        if (claim == null) {
            return 0;
        }
        if (!ExpandCommand.checkExpandPermission((CommandSourceStack)context.getSource(), player, claim, mode)) {
            return 0;
        }
        if (amount <= 0) {
            ExpandCommand.sendExpandError((CommandSourceStack)context.getSource(), "flan.invalidDistance", new Object[0]);
            return 0;
        }
        Direction facing = player.getDirection();
        if (!(claim.is3d() && mode.is3d || facing != Direction.UP && facing != Direction.DOWN)) {
            ExpandCommand.sendExpandError((CommandSourceStack)context.getSource(), facing == Direction.UP ? "flan.expandUpDisabled" : "flan.expandDownDisabled", new Object[0]);
            return 0;
        }
        ClaimBox dims = claim.getDimensions();
        Pair<BlockPos, BlockPos> corners = ExpandCommand.calculateCorners(dims, facing, amount, claim.parentClaim() != null ? claim.parentClaim().getDimensions() : null);
        boolean success = ExpandCommand.performExpansion(player, storage, claim, corners);
        if (!success) {
            ExpandCommand.sendExpandError((CommandSourceStack)context.getSource(), "flan.expandFailed", new Object[0]);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.expandSuccess", amount, ChatFormatting.GREEN), false);
        return 1;
    }

    private static Pair<BlockPos, BlockPos> calculateCorners(ClaimBox dims, Direction facing, int amount, ClaimBox restriction) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.SOUTH -> Pair.of((Object)new BlockPos(dims.maxX(), dims.minY(), dims.maxZ()), (Object)new BlockPos(dims.maxX(), dims.maxY(), restriction != null ? Math.min(dims.maxZ() + amount, restriction.maxZ()) : dims.maxZ() + amount));
            case Direction.EAST -> Pair.of((Object)new BlockPos(dims.maxX(), dims.minY(), dims.maxZ()), (Object)new BlockPos(restriction != null ? Math.min(dims.maxX() + amount, restriction.maxX()) : dims.maxX() + amount, dims.maxY(), dims.maxZ()));
            case Direction.NORTH -> Pair.of((Object)new BlockPos(dims.minX(), dims.minY(), dims.minZ()), (Object)new BlockPos(dims.minX(), dims.maxY(), restriction != null ? Math.max(dims.minZ() - amount, restriction.minZ()) : dims.minZ() - amount));
            case Direction.WEST -> Pair.of((Object)new BlockPos(dims.minX(), dims.minY(), dims.minZ()), (Object)new BlockPos(restriction != null ? Math.max(dims.minX() - amount, restriction.minX()) : dims.minX() - amount, dims.maxY(), dims.minZ()));
            case Direction.UP -> Pair.of((Object)new BlockPos(dims.minX(), dims.maxY(), dims.minZ()), (Object)new BlockPos(dims.maxX(), restriction != null ? Math.min(dims.maxY() + amount, restriction.maxY()) : dims.maxY() + amount, dims.maxZ()));
            case Direction.DOWN -> Pair.of((Object)new BlockPos(dims.minX(), dims.minY(), dims.minZ()), (Object)new BlockPos(dims.maxX(), restriction != null ? Math.max(dims.minY() - amount, restriction.minY()) : dims.minY() - amount, dims.maxZ()));
        };
    }

    private static Claim findClaim(CommandSourceStack source, ServerPlayer player, ClaimStorage storage, ClaimMode mode) {
        Claim claim = storage.getClaimAt(player.blockPosition());
        if (claim == null) {
            source.sendFailure((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.DARK_RED));
            return null;
        }
        if (mode.isSubclaim) {
            Claim subClaim = claim.getSubClaim(player.blockPosition());
            if (subClaim == null) {
                source.sendFailure((Component)ClaimUtils.translatedText("flan.noSubClaim", ChatFormatting.RED));
                return null;
            }
            return subClaim;
        }
        return claim;
    }

    private static boolean performExpansion(ServerPlayer player, ClaimStorage storage, Claim claim, Pair<BlockPos, BlockPos> corners) {
        if (claim.isSubclaim()) {
            Claim parent = claim.parentClaim();
            if (parent == null) {
                return false;
            }
            Set<Claim> conflicts = parent.resizeSubclaim(claim, (BlockPos)corners.getFirst(), (BlockPos)corners.getSecond());
            return conflicts.isEmpty();
        }
        return storage.resizeClaim(claim, (BlockPos)corners.getFirst(), (BlockPos)corners.getSecond(), player);
    }

    private static boolean checkExpandPermission(CommandSourceStack source, ServerPlayer player, Claim claim, ClaimMode mode) {
        if (mode.isSubclaim) {
            Claim parent = claim.parentClaim();
            if (parent == null || !claim.canInteract(player, BuiltinPermission.EDITCLAIM, player.blockPosition()) || !parent.canInteract(player, BuiltinPermission.EDITCLAIM, player.blockPosition())) {
                source.sendFailure((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED));
                return false;
            }
        } else if (!claim.canInteract(player, BuiltinPermission.EDITCLAIM, player.blockPosition())) {
            source.sendFailure((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED));
            return false;
        }
        return true;
    }

    private static void sendExpandError(CommandSourceStack source, String key, Object ... args) {
        source.sendFailure((Component)ClaimUtils.translatedText("flan.expandError", ClaimUtils.translatedText(key, args)).withStyle(ChatFormatting.RED));
    }
}

