/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class NameClaimCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"name").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.name"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(NameClaimCommand::nameClaim)));
    }

    private static int nameClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = CommandClaim.getClaimFromMode(context, player, BuiltinPermission.EDITPERMS);
        if (claim == null) {
            return 0;
        }
        boolean nameUsed = claim.isSubclaim() ? claim.getAllSubclaims().stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name"))) : ClaimStorage.get(((CommandSourceStack)context.getSource()).getLevel()).allClaimsFromPlayer(claim.getOwner()).stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name")));
        if (nameUsed) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.claimNameUsed", ChatFormatting.DARK_RED));
            return 0;
        }
        String name2 = StringArgumentType.getString(context, (String)"name");
        claim.setClaimName(name2);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.claimNameSet", name2, ChatFormatting.GOLD), false);
        return 1;
    }
}

