/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class OpenMenuCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"menu").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.menu"))).executes(OpenMenuCommand::openMenu));
    }

    private static int openMenu(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = ClaimStorage.get(player.serverLevel()).getClaimAt(player.blockPosition());
        if (claim == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.DARK_RED));
            return 0;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (!data.getClaimMode().isSubclaim) {
            ClaimMenuScreenHandler.openClaimMenu(player, claim);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
        } else {
            Claim sub = claim.getSubClaim(player.blockPosition());
            if (sub == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noSubClaim", ChatFormatting.DARK_RED));
                return 0;
            }
            ClaimMenuScreenHandler.openClaimMenu(player, sub);
        }
        return 1;
    }
}

